# -*- coding: utf-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import os
from enum import unique, Enum

HTTP_SUCCESS_CODE = 200
ERROR_RET_CODE = 1
SUCCESS_RET_CODE = 0
DEFAULT_PAGE = 1
DEFAULT_PAGESIZE = 50
# 工作目录
WORK_DIR = os.path.abspath(os.path.join(os.path.split(os.path.realpath(__file__))[0], ".."))
# 日志目录
LOG_DIR = "/opt/oss/log/manager/HardwareAlarmCheck"
# 日志文件
HEALTH_CHECK_LOG = os.path.join(LOG_DIR, "alarm_param_check.log")
# SSH远程执行命令工具
SSH_CMD = os.path.join(WORK_DIR, "shell", "ssh_cmd.sh")
# 本地执行sql命令工具
SQL_CMD = os.path.join(WORK_DIR, "shell", "get_hardware_service.sh")


@unique
class InstallType(Enum):
    SINGLE = 0  # 单管
    MINI = 1  # 小型化
    DISTRIBUTED = 2  # 分布式
    UNKNOWN = -1


@unique
class ServiceType(Enum):
    SERVER = "service"  # 服务器
    FC = "fcService"  # FC
    SWITCH = "switchService"  # 交换机


CHECK_MAP = {
    # 单管场景仅检查服务器
    InstallType.SINGLE: [ServiceType.SERVER.value],
    # 小型化场景检查服务器、FC
    InstallType.MINI: [ServiceType.SERVER.value, ServiceType.FC.value],
    # 分布式场景检查服务器、FC、交换机
    InstallType.DISTRIBUTED: [ServiceType.SERVER.value, ServiceType.FC.value, ServiceType.SWITCH.value],
    # 其它场景忽略
    InstallType.UNKNOWN: []
}


@unique
class RetCode(Enum):
    SUCCESS_CODE = "0"
    PING_ERROR = "1"
    CONNECT_ERROR = "2"
    ALARM_RECEIVE_PARAM_NOT_EXIST_ERROR = "3"
    ALARM_RECEIVE_PARAM_ERROR = "4"
    ALARM_FORWARD_PARAM_ERROR = "5"
    HARDWARE_INFO_NOT_EXIST_DISTRIBUTED = "6"
    HARDWARE_INFO_NOT_EXIST_MINI = "7"
    HARDWARE_INFO_NOT_EXIST_SINGLE = "8"
