# -*- coding: utf-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

class AlarmForwardParam(object):
    """ 告警转发参数(服务器/交换机上配置的参数) """

    def __init__(self, ip, user, port):
        self.snmp_user = user
        self.snmp_ip = ip
        self.snmp_port = port

    def match(self, ip, user, port):
        """ 判断告警转发参数配置是否正确 """
        return ip == self.snmp_ip and user == self.snmp_user and port == self.snmp_port

    def __str__(self):
        return f"[user:{self.snmp_user}][ip:{self.snmp_ip}][port:{self.snmp_port}]"
