# -*- coding: utf-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from util import ossext


class ServiceInfo(object):
    """ 健康检查服务实例 """

    def __init__(self, service_ip, service_user, service_pwd, service_type):
        self.service_ip = service_ip
        self.service_user = service_user
        self.encrypt_pwd = service_pwd
        self.service_type = service_type

    @property
    def pwd(self):
        return ossext.Cipher.decrypt(self.encrypt_pwd)

    def __str__(self):
        return f"{self.service_type}:{self.service_ip}"


def get_service_info(info: dict) -> ServiceInfo:
    """ 获取健康检查实例 """
    return ServiceInfo(info.get("nodeIp"), info.get("userName"), info.get("password"), info.get("serviceType"))
