# -*- coding: utf-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from exception.exception import HealthCheckException
from service.fc_service import FCService
from service.server_service import ServerService
from service.service import Service
from service.switch_service import SwitchService
from data.service_info import ServiceInfo
from constant.constant import ServiceType, CHECK_MAP
from utils.log_utils import get_logger
from utils.manager import Manager

LOGGER = get_logger()


class ServiceFactory(object):
    """ 健康检查服务 工厂"""

    def __init__(self, service_info: ServiceInfo):
        self._service_info = service_info

    def get_service(self) -> Service:
        """ 获取健康检查服务实例 """
        if self._service_info.service_type == ServiceType.SERVER.value:
            return ServerService(self._service_info)
        if self._service_info.service_type == ServiceType.FC.value:
            return FCService(self._service_info)
        if self._service_info.service_type == ServiceType.SWITCH.value:
            return SwitchService(self._service_info)
        raise HealthCheckException(f"service factory get wrong service type: {self._service_info.service_type}")


def get_service_list(service_info_list):
    """ 获取健康检查实例列表,根据安装场景进行过滤 """
    install_type = Manager().install_type
    check_list = CHECK_MAP.get(install_type)
    LOGGER.info(f"get install type is {install_type}, check service list is {check_list}")
    return [ServiceFactory(service_info).get_service() for service_info in service_info_list if
            service_info.service_type in check_list]
