#!/bin/bash
#####################################################################################
#
# Copyright © Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.
#
# Description: 执行本地sql命令
#
# Usage： bash sql_cmd.sh <DATABASE> <IP> <PORT>
#
# Output: 执行结果
#
#####################################################################################

DATABASE=$1
IP=$2
PORT=$3
CMD="SELECT SERVER_TYPE,HARDWARE_IP,HARDWARE_USERNAME,HARDWARE_PASSWD FROM tbl_hardware_info;"
read -sr PWD
PWD=$(echo ${PWD} | sed 's/\\/\\\\/g' | sed 's/}/\\}/g' | sed 's/{/\\{/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')

# 超时退出
RETURN_TIMEOUT=201
# 连接失败
RETURN_CONNECT_FAILED=202
# 连接拒绝
RETURN_CONNECTION_REFUSED=203
# 连接无权限
RETURN_CONNECT_PERMISSION_DENIED=204
# 成功退出
RETURN_SUCCESS_CODE=0
# 超时时间
TIMEOUT=20


##################################################
# expect命令远程执行命令
##################################################
function exec_cmd() {
    expect_output=$(expect << ENF
    set timeout ${TIMEOUT}
    spawn sudo -i -u dbuser zsql ${DATABASE}@${IP}:${PORT}
    expect {
        "*No route to host*" { exit ${RETURN_CONNECT_FAILED} }
        "*Name or service not known*" { exit ${RETURN_CONNECT_FAILED} }
        "*Connection refused*" { exit ${RETURN_CONNECTION_REFUSED} }
        "*Permission denied*" { exit ${RETURN_CONNECT_PERMISSION_DENIED} }
        "*Name or service not known*" { exit ${RETURN_CONNECT_FAILED} }
        "*Connection reset*" { exit ${RETURN_CONNECT_PERMISSION_DENIED} }
        "*assword:" { send -- "${PWD}\r" }
    }

    expect {
        "*QL*" { send "${CMD}\r" }
        timeout { exit ${RETURN_TIMEOUT} }
    }

    expect {
        "*QL*" { exit ${RETURN_SUCCESS_CODE} }
    }
    expect timeout { exit ${RETURN_TIMEOUT} }
    expect eof
ENF
)
    return_code=$?
    echo "${expect_output}"
    return ${return_code}
}


##################################################
# 入口方法
##################################################
function main() {
    exec_cmd
    return $?
}

#############################################
# 仅允许ossadm用户调用
#############################################
[ "$(whoami)" == "ossadm" ] && {
  main "$@"
  exit $?
}
echo "Only the ossadm user can run this script."
exit 1
