#!/bin/bash
##############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# File name: check_directory_mount.sh
# Description: 检查mnt目录是否挂载
##############################################################################

#########################
# Description: 程序主入口
#########################
function check_directory_mount(){
    mount | grep "/mnt " | grep -w "ro" &>> /dev/null
    if [ $? -eq 0 ];then
        echo "ERROR: /mnt is mounted read-only, the change of ownership and permissions will fail. This will then cause an error to be reported when upgrading the operating system."
        return 1
    fi
    return 0
}

check_directory_mount
exit $?