#!/bin/bash
##############################################################################
# Copyright © Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
# File name: check_file_is_exist.sh
# Description: 检查关键文件是否存在
##############################################################################

CUR_PATH=$(cd $(dirname $0);pwd)
FILE_LIST="${CUR_PATH}/conf/key_file_list"

#########################
# Description: 编辑FILE_LIST，特殊场景下，需要额外检查的文件
#########################
function edit_file_list(){
    # 如果有锁服务(/usr/lib/systemd/system/lock.service)，则要求/etc/lock/run/endlockservice.sh存在
    [ -f /usr/lib/systemd/system/lock.service ] && echo "/etc/lock/run/endlockservice.sh" >> "${FILE_LIST}"
    edit_file_list_by_euleros
}

#########################
# Description: 编辑欧拉场景下场景下，需要额外检查的文件
#########################
function edit_file_list_by_euleros(){
    uname -r | grep euleros &>> /dev/null
    [ $? -ne 0 ] && return 0
    # 欧拉操作系统，则要求/bin/yum,/etc/euleros-latest存在
    echo "/bin/yum" >> "${FILE_LIST}"
    echo "/etc/euleros-latest" >> "${FILE_LIST}"
    # R7 操作系统没有dnf相关rpm包
    uname -r | grep eulerosv2r7 &>> /dev/null
    if [ $? -ne 0 ];then
        echo "/etc/dnf/dnf.conf" >> "${FILE_LIST}"
    fi
}

#########################
# Description: 检查列表中的文件是否存在
#########################
function check_file_is_exist(){

    local return_code=0
    while read line || [[ -n ${line} ]];
    do
        if [ ! -f "${line}" ];then
            echo "ERROR: The file ${line} does not exist. The OS upgrade will be affected. Please check the environment"
            return_code=1
        elif [ ! -s "${line}" ];then
            echo "ERROR: The file ${line} exists but the content is empty. The OS upgrade will be affected. Please check the environment"
            return_code=1
        fi
    done <<< "$(cat ${FILE_LIST} | grep -v '^#' | grep -v '^$')"
    return ${return_code}
}

edit_file_list
check_file_is_exist
exit $?