# encoding=utf-8
"""
功 能：切换容灾浮动IP
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2022-08-17 12:00 创建
"""
import os
import sys

# 配置模块引用查询路径
file_path = os.path.dirname(os.path.realpath(__file__))
# python工作路径
py_script_path = os.path.join(os.path.dirname(os.path.dirname(file_path)), 'pyscripts')
# 配置引用路径
sys.path.append(py_script_path)

from commonlog import Logger
from taskmgr_util import Taskmgrutil

LOG = Logger().getinstance(sys.argv[0])


def enable_dr_float_ip(task_path, product_name):
    """
    功能说明:启用容灾浮动IP
    :param task_path：任务工作路径
    :param product_name:产品名
    :return:
    """
    Taskmgrutil.set_task(task_path, msg="Start to start the floating IP address of the site DR.")
    cmd = "bash /opt/oss/manager/apps/DRMgrService/bin/dr_floatingip.sh" \
          f" -type glbfloatingip -pn {product_name} -action active"
    ret_code, output = Taskmgrutil.execute_cmd(cmd)
    LOG.info(f"cmd:{cmd} ret_code:{ret_code} output:{output}")
    if ret_code != 0:
        Taskmgrutil.set_task(task_path, status="error", progress="100",
                             msg="Failed to start the floating IP address of the site DR.")
        return False
    Taskmgrutil.set_task(task_path, status="success", progress="100",
                         msg="Finished to start the floating IP address of the site DR.")
    return True


def disable_dr_float_ip(task_path, product_name):
    """
    功能说明:禁用容灾浮动IP
    :param task_path：任务工作路径
    :param product_name:产品名
    :return:
    """
    Taskmgrutil.set_task(task_path, msg="Start to stop the floating IP address of the site DR.")
    Taskmgrutil.set_task(task_path, status="RUNNING", progress="0")
    cmd = "bash /opt/oss/manager/apps/DRMgrService/bin/dr_floatingip.sh" \
          f" -type glbfloatingip -pn {product_name} -action deactive"
    ret_code, output = Taskmgrutil.execute_cmd(cmd)
    LOG.info(f"cmd:{cmd} ret_code:{ret_code} output:{output}")
    if ret_code != 0:
        Taskmgrutil.set_task(task_path, status="error", progress="100",
                             msg="Failed to stop the floating IP address of the site DR.")
        return False
    Taskmgrutil.set_task(task_path, status="success", progress="100",
                         msg="Finished to stop the floating IP address of the site DR.")
    return ret_code


def main(argv):
    """
    功能说明:浮动IP切换主入口
    :param argv:调用入参
    """
    task_id = argv[1]
    product_name = argv[2]
    action = argv[3]
    task_path = os.path.join("/opt/upgrade/easysuite_upgrade/taskmgr", task_id)

    # 初始化任务
    Taskmgrutil().init_e_taskmgr(task_path)
    Taskmgrutil.set_task(task_path, status="running", progress="0")
    if action == "--enable":
        return enable_dr_float_ip(task_path, product_name)
    return disable_dr_float_ip(task_path, product_name)


if __name__ == '__main__':
    main(sys.argv)

