# encoding=utf-8
"""
功 能：删除旧版本license文件
版权信息：华为技术有限公司，版本所有(C) 2020-2029
修改记录：2020-09-09 12:00 创建
"""
import os
import sys
import json
import time
from util import common
from util import httpclient
from commonlog import Logger

LOGGER = Logger().getinstance(sys.argv[0])
OSS_ROOT = os.popen("echo $OSS_ROOT").read().strip()
SERVICE_NAME = "SMPManagerService"
QUERY_TOKENS_URL = "/rest/sia/v1/tokens/jwt/sia"
OPERATE_LICENSE_URL = "/rest/plat/license/v1/licensefile"
PRODUCT_NODE_LIST = []
NO_SIA = "with_out_sia"


def get_product_node_ip():
    """
    功能描述：获取产品服务节点
    :return:
    """
    LOGGER.info("[delete_old_license.get_product_node_ip] Get product node info.")
    result_product_node = dict()
    url = '/rest/plat/omp/v1/main/resmgr/nodes'
    result = httpclient.IRHttpClient().get(url)
    if not isinstance(result, tuple) and result[0] != 200:
        LOGGER.error("[delete_old_license.get_product_node_ip]"
                     " get url: %s, result: %s." % (url, str(result)))
        return result_product_node
    node_info_list = json.loads(result[1])
    for node_info in node_info_list:
        result_node_name = node_info.get("nodeName", "")
        result_node_ip = node_info.get("manageIP", "")
        result_product_name = node_info.get("productUri", "").split("/")[-1]
        if result_node_name.lower().find("gw") != -1:
            continue
        if result_product_name not in result_product_node.keys():
            result_product_node.update({result_product_name: list()})
        result_product_node[result_product_name].append({
            "node_name": result_node_name,
            "manage_ip": result_node_ip
        })
    LOGGER.info("[get_product_node_ip] product all node list: %s." % result_product_node)
    return result_product_node


def get_del_license_param(config_info):
    """
    功能描述：解析输入参数,格式"${productName1}:${productVersion1};${productName2}:${productVersion2}"
    :param config_info:
    :return:
    """
    try:
        config_info_param = []
        config_info_list = config_info.split(",")
        LOGGER.info("[delete_old_license.get_del_license_param] Input param: %s" % config_info)
        for info in config_info_list:
            product_name = info.split("_+_")[0]
            product_version = info.split("_+_")[1]
            if not product_name or not product_version:
                continue
            tmp_param = {
                "productName": product_name,
                "productVersion": product_version
            }
            if tmp_param not in config_info_param:
                config_info_param.append(tmp_param)
        LOGGER.info("[delete_old_license.get_del_license_param]"
                    " Output param: %s" % config_info_param)
        return config_info_param
    except IndexError as error:
        LOGGER.error("[delete_old_license.get_del_license_param]"
                     " get del license param, Exception: %s" % error)
        return []


def get_service_jwt():
    """
    功能描述：获取jwt配置信息
    :return:
    """
    jwt_file = "%s/apps/%s/etc/authconf/jwt/jwt_%s.json" % (OSS_ROOT, SERVICE_NAME, SERVICE_NAME)
    if not os.path.isfile(jwt_file):
        LOGGER.error("[delete_old_license.get_service_jwt]"
                     " The %s file does not exist." % str(jwt_file))
        return {}
    with open(jwt_file, "r") as fob:
        file_dict = json.load(fob)
        file_dict.update({
            "domain": SERVICE_NAME
        })
    return file_dict


def get_sia_token():
    """
    功能描述：获取token配置信息
    :return:
    """
    jwt_config = get_service_jwt()
    if not jwt_config:
        LOGGER.error("[delete_old_license.get_sia_token] No sia")
        # 无鉴权文件,无SIA方式调用
        return NO_SIA
    if "jwt" in jwt_config and "domain" in jwt_config:
        local_node_ip = common.getLocalIP() if hasattr(common, 'getLocalIP') else \
            common.get_local_ip()
        client = httpclient.CommonHttpClient(local_node_ip, 32038, True, False)
        result = client.post(QUERY_TOKENS_URL, jwt_config)
        if not isinstance(result, tuple) and result[0] != 200:
            LOGGER.error("[delete_old_license.get_sia_token]"
                         f" post url: {QUERY_TOKENS_URL}, result: {result}.")
            return ""
        if result != 200:
            LOGGER.error("[delete_old_license.get_sia_token] "
                         f"No sia.Post url:{QUERY_TOKENS_URL}, result: {result}.")
            # 请求非 200 按无SIA方式调用
            return NO_SIA
        token = json.loads(result[1])
        if "token" in token:
            return token.get("token", "")
    LOGGER.error("[delete_old_license.get_sia_token] jwt_config: %s." % str(jwt_config))
    return ""


def init_common_client(product_node_ip, token_config):
    """
    功能描述：初始化query连接
    :param product_node_ip:
    :param token_config:
    :return:
    """
    if token_config != NO_SIA:
        headers = {
            "x-access-token": token_config
        }
        return httpclient.CommonHttpClient(product_node_ip, 32018, True, False, headers=headers)
    return httpclient.CommonHttpClient(product_node_ip, 32018, True, False)


def delete_old_license(common_client, license_list, del_license_list):
    """
    功能描述：删除旧版本license
    :param common_client:
    :param license_list:
    :param del_license_list:
    :return:
    """
    query_license_list = []
    operate_license_param_list = []
    for license_config in license_list:
        product_name = license_config.get("productName", "")
        product_version = license_config.get("productVersion", "")
        query_license_list.append({
            "licenseProductName": product_name,
            "licenseProductVer": product_version
        })
        for del_license in del_license_list:
            del_product_name = del_license.get("productName", "")
            del_product_version = del_license.get("productVersion", "")
            if product_name != del_product_name:
                continue
            if product_version != del_product_version:
                continue
            operate_license_param_list.append({
                "licenseProductName": product_name,
                "licenseProductVer": product_version
            })

    LOGGER.info("[delete_old_license.delete_old_license]"
                " Query list: %s." % query_license_list)
    LOGGER.info("[delete_old_license.delete_old_license]"
                " Config delete list: %s." % del_license_list)
    LOGGER.info("[delete_old_license.delete_old_license]"
                " Delete param: %s." % operate_license_param_list)
    if operate_license_param_list:
        # 执行删除操作
        result = common_client.put(OPERATE_LICENSE_URL, operate_license_param_list)
        if not isinstance(result, tuple) or result[0] != 200:
            LOGGER.error("[delete_old_license.delete_old_license] Failed to delete"
                         " the license, url: %s, result: %s" % (OPERATE_LICENSE_URL, str(result)))
            return 1
        # 升级后检查操作
        result = common_client.get(OPERATE_LICENSE_URL)
        if not isinstance(result, tuple) or result[0] != 200:
            LOGGER.error("[delete_old_license.delete_old_license] Failed to query after"
                         " deletion, url: %s, result: %s" % (OPERATE_LICENSE_URL, str(result)))
            return 1
        delete_after_len = len(license_list) - len(operate_license_param_list)
        if delete_after_len == len(json.loads(result[1])):
            LOGGER.info("[delete_old_license.delete_old_license] INFO :"
                        " The license of the old version is deleted successfully.")
            return 0
    LOGGER.warning("[delete_old_license.delete_old_license] The parameters for"
                   " deleting the license are not configured or the license is not imported.")
    return 0


def main(argv):
    """
    功能描述：程序入口
    :param argv:
    :return:
    """
    # 解析子域配置的删除license参数
    del_license_list = get_del_license_param(argv[1])
    if not del_license_list:
        LOGGER.error("[delete_old_license.main] The configuration file is abnormal.")
        return 1

    # 获取环境token信息
    token_config = get_sia_token()
    if not token_config and token_config != NO_SIA:
        LOGGER.error("[delete_old_license.main] Failed to obtain the token.")
        return 1

    product_node_map = get_product_node_ip()
    if not product_node_map:
        LOGGER.error("[delete_old_license.main] Failed to obtain the product node information.")
        return 1

    exec_flag = 0
    license_list = None
    common_client = None
    for product_name, node_list in product_node_map.items():
        for node_info in node_list:
            # 获取产品节点
            product_node_ip = node_info["manage_ip"]
            product_node_name = node_info["node_name"]
            LOGGER.info("[delete_old_license.main] product: %s,"
                        " node:%s, IP:%s." % (product_name, product_node_name, product_node_ip))
            if product_node_ip == "":
                LOGGER.warning("[delete_old_license.main] Failed"
                               " to obtain the IP address of the SMLog node.")
                time.sleep(3)
                continue

            # 初始化common_client连接
            common_client = init_common_client(product_node_ip, token_config)
            if common_client is None:
                LOGGER.warning("[delete_old_license.main] Failed to init client.")
                time.sleep(3)
                continue

            # 查询license配置
            result = common_client.get(OPERATE_LICENSE_URL)
            if not isinstance(result, tuple) or result[0] != 200:
                LOGGER.warning("[delete_old_license.main] Failed to query the"
                               " license, url: %s, result: %s" % (OPERATE_LICENSE_URL, str(result)))
                time.sleep(3)
                continue
            license_list = json.loads(result[1])
            break
        if license_list is None:
            LOGGER.warning("[delete_old_license.main] Failed to query the license.")
            return 1
        if not license_list:
            LOGGER.info("[delete_old_license.main] INFO :"
                        " The license of the old version is deleted successfully.")
            continue

        # 删除license配置
        exec_result = delete_old_license(common_client, license_list, del_license_list)
        if exec_result != 0:
            exec_flag = exec_result
    return exec_flag


if __name__ == '__main__':
    sys.exit(main(sys.argv))
