# encoding=utf-8
"""
功 能：删除旧版本license文件
版权信息：华为技术有限公司，版本所有(C) 2020-2029
修改记录：2023-04-14 11:00 创建
"""
import os
import sys
import json
import stat


def generate_error_code(error_code_json_file, key_error_code_type, target_file,refresh_mes=None):
    if not os.path.isfile(error_code_json_file):
        return False

    with open(error_code_json_file, 'r') as f:
        data = json.load(f)

    error_code_detail = data.get(key_error_code_type)
    if not error_code_detail:
        return False
    # 更新具体失败ip节点信息
    if refresh_mes:
        error_code_detail = json.dumps(error_code_detail).replace('${ip}', refresh_mes)
        error_code_detail = json.loads(error_code_detail)

    # 适配EasySuit错误码框架
    res = {"exc_migrate_NCE-Common.sh.json": error_code_detail}
    # 写入json文件
    fd = os.open(target_file, os.O_CREAT | os.O_WRONLY | os.O_TRUNC, stat.S_IRUSR | stat.S_IWUSR | stat.S_IRGRP)
    with os.fdopen(fd, "w") as file_obj:
        file_obj.write(json.dumps(res))

    return True


def main(argv):
    error_code_json_file = str(argv[1])
    key_error_code_type = str(argv[2])
    target_file = str(argv[3])
    refresh_mes = None
    if len(argv) > 4:
        refresh_mes = str(argv[4])
    return generate_error_code(error_code_json_file, key_error_code_type, target_file, refresh_mes)


if __name__ == '__main__':
    main(sys.argv)
