import sys
import os

from util import httpclient
from commonlog import Logger

logger = Logger().getinstance(sys.argv[0])

NORMAL_STATUS = [200, 207]
SUCCESS = 0
FAIL_GET = 1
FAIL_WRITE = 2
UNKNOWN_ERROR = 3
PARAMS_ERROR = 4


def download_report(url):
    """
    调用接口，下载报表
    :param url:
    :return:
    """
    _HttpClient = httpclient.IRHttpClient()
    code, response = _HttpClient.get(url)
    logger.info(f"[download_report] url: {url}, code: {code}, response: {response}")
    if NORMAL_STATUS[0] <= code <= NORMAL_STATUS[1]:
        return response
    logger.error(f"[download_report] Failed to download report.")
    sys.stderr.write(f"[download_report] Failed to download report.url:{url}, code:{code}." + "\n")
    return ""


def write_report_file(file_path, context):
    """
    将数据写入文件
    :param file_path:
    :param context:
    :return:
    """
    try:
        with open(file_path, 'wb') as r_stream:
            r_stream.write(context)
        os.chmod(file_path, 0o600)
    except Exception as e:
        logger.error(f"[write_report_file] Failed to write report file: {file_path}, Exception:{e}" + "\n")
        sys.stderr.write(f"[write_report_file]  Failed to write report file: {file_path}, Exception:{e}" + "\n")
        if os.path.exists(file_path):
            os.remove(file_path)
        return False
    return True


def main(argv):
    """
    :param argv:
    :return:
    """
    # 对入参数量进行校验，第一个参数是当前文件名
    if len(argv) != 4:
        logger.error(f"[main] params error.")
        return PARAMS_ERROR
    report_file = argv[1]
    hc_task_id = argv[2]
    task_ip = argv[3]
    if task_ip == "none":
        url = '/rest/smpmanagerwebsite/v1/healthcheck/batch_download?taskId={0}'.format(hc_task_id)
    else:
        url = '/rest/smpmanagerwebsite/v1/healthcheck/hc_download?taskId={0}' \
              '&taskIp={1}'.format(hc_task_id, task_ip)
    try:
        report_dir = os.sep.join(report_file.split(os.sep)[0: -1])
        if not os.path.isdir(report_dir):
            os.makedirs(report_dir)
        response = download_report(url)
        if not response:
            return FAIL_GET
        if not write_report_file(report_file, response):
            return FAIL_WRITE
        return SUCCESS
    except Exception as e:
        logger.error(f"[main]Failed to download report.Exception:{e}" + "\n")
        sys.stderr.write(f"[main]Failed to download report.Exception:{e}" + "\n")
        return UNKNOWN_ERROR


if __name__ == '__main__':
    result = main(sys.argv)
    exit(result)
