# encoding=utf-8
"""
功 能：记录日志
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import json
import os
import sys

from commonlog import Logger
from taskmgr_util import Taskmgrutil
from upgrade_custom import UpgradeCustom

logger = Logger().getinstance(sys.argv[0])

INFO = "INFO"
WARN = "WARNING"
ERROR = "ERROR"


class OperatePreCustom(UpgradeCustom):
    def __init__(self, args):
        self.productlist = args.get("productlist", "").split(",")
        self.src_version = args.get("src_version", "")
        self.des_version = args.get("des_version", "")
        self.site = args.get("site", "")
        self.action = args.get("action", "")
        self.scriptid = args.get("scriptid", "")
        self.cmd_reminder_time = int(args.get("cmd_reminder_time", 0)) * 60
        self.is_protection_hot = args.get("is_protection_hot", "")
        self.single_mgr_domain = args.get("single_mgr_domain", "")
        self.pre_custom_dir = "/opt/upgrade/backup/workpath/"
        self.scriptpath = "/opt/upgrade/easysuite_upgrade/scripts"
        self.workpath = "/opt/upgrade/easysuite_upgrade/workpath/%s-%s" % (
            self.src_version, self.des_version)
        self.workfile = os.path.join(self.workpath, "pre_custom_input.json")
        self.taskpath = os.path.join("/opt/upgrade/easysuite_upgrade/taskmgr", self.scriptid)
        self.taskmsg = os.path.join(self.taskpath, "task.log")
        self.taskstatus = os.path.join(self.taskpath, "task.status")
        self.taskprogress = os.path.join(self.taskpath, "task.process")
        self.taskmgr_function = Taskmgrutil()
        self.taskmgr_function.init_e_taskmgr(self.taskpath)
        self.msg = ""
        # 判断线程是否有失败
        self.thread_flag = True
        # 初始化
        os.system("mkdir -p %s" % self.workpath)
        Taskmgrutil.initial_error_path(self.workpath)

    def gen_param(self):
        """
        生成升级参数文件
        """
        param = {}
        param.update({"productlist": self.productlist})
        for product in self.productlist:
            product_filename = f"upgrade_params_config_{product}_{self.src_version}-{self.des_version}.json"
            param.update({product: os.path.join(self.pre_custom_dir, product_filename)})
        param.update({"src_version": self.src_version})
        param.update({"des_version": self.des_version})
        param.update({"is_protection_hot": self.is_protection_hot})
        param.update({"single_mgr_domain": self.single_mgr_domain})
        param.update({"site": self.site})
        with os.fdopen(os.open(self.workfile,
                               os.O_CREAT | os.O_WRONLY | os.O_TRUNC,
                               mode=0o660), "w", encoding="utf-8") as file_obj:
            json.dump(param, file_obj, indent=4)
        return True

    def format_script_cmd(self, script, error_path):
        cmd = f"bash {script} -input {self.workfile} -error_path {error_path}"
        return cmd

def main(argv):
    args = {}
    args.update({"src_version": argv[2], "des_version": argv[4], "productlist": argv[6],
                 "site": argv[8], "is_protection_hot": argv[10], "single_mgr_domain": argv[12],
                 "action": argv[14],
                 "scriptid": argv[16]})

    custom_function = OperatePreCustom(args)
    return custom_function.main_entry()


if __name__ == '__main__':
    main(sys.argv)
