# -*- coding:utf-8 -*-
"""
功 能：产品运维面升级二段式升级第二段
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2021-01-11 17:00 创建
"""
import json
import os
import sys
import time
import threading

from commonlog import Logger
from operate_product import Operateproduct
from operate_product import TaskStatus
from operate_product_util import OperateProductUtil
from taskmgr_util import Taskmgrutil

logger = Logger().getinstance(sys.argv[0])

INFO = "INFO"
WARN = "WARNING"
ERROR = "ERROR"


class OperateproductSecondPhase(Operateproduct):
    """
    产品部署失败状态只有重试场景可以进入
    初次创建任务不支持部署失败状态直接部署产品
    """
    def retry_product(self, task_id_path):
        """
        功能说明:重试部署任务
        :param task_id_path:
        :return:
        """
        product_info = self.query_product_info()
        product_deployid = product_info.get("deployId")
        product_id = product_info.get("productId")
        logger.info("[function_name:%s] product_deployid:%s" % (
            self.get_function_name(), product_deployid))
        deploy_status = product_info.get("deploy_status")
        if deploy_status == TaskStatus.error:
            status, response = self.unieptask_function.send_put_request(
                self.retry_product_url % (product_deployid, self.productname))
            if status is False:
                return 1
            # 查询进度等待任务执行完成
            self.wait_product_task(response, product_id, product_deployid, task_id_path)
            return 0
        return 2

    @staticmethod
    def is_deploy_success(params_dict, upgrade_deploy_data):
        condition = True
        product_name = params_dict.get("productName")
        target_version = upgrade_deploy_data.get("target_version")
        logger.info("product_name:%s target_version:%s" % (product_name, target_version))
        # 检查部署状态是否为成功
        current_deploy_status = params_dict.get('deploy_status')
        logger.info("current_deploy_status:%s" % current_deploy_status)
        if current_deploy_status != 'DEPLOY_SUCCESS':
            condition = False
        if condition and not OperateProductUtil.modify_product_version(product_name,
                                                                       target_version):
            logger.error("OperateProductUtil.modify_product_version,result:False")
        return condition

    def upgrade_product_secondphase(self, target_version, task_id_path, upgrade_new_param):
        """
        功能描述：升级产品第二段
        :param target_version: 目标版本
        :param task_id_path: 界面日志路径
        :param upgrade_new_param: 二阶段升级添加的参数
        """
        __taskmsg = os.path.join(task_id_path, "task.log")
        self.plandata_path = os.path.join(self.workpath, "plandata")
        ret_code = self.retry_product(task_id_path)
        if ret_code == 0:
            return True
        elif ret_code == 1:
            return False

        upgrade_deploy_data = {"target_version": target_version}

        params_dict = self.query_product_info()

        # 任务是否已部署完成
        deploy_result = self.is_deploy_success(params_dict, upgrade_deploy_data)
        if deploy_result:
            self.print_msg(INFO,
                           "The second phase of the upgrade is already complete.(%s)" % self.productname)
            self.set_task_data("success", "100")
            return True

        self.print_msg(INFO,
                       "Start to execute the second phase of the upgrade.(%s)" % self.productname)

        # 记录开始时间
        ipmc_tool_start_time = time.time()
        # 处理第二段升级新添加的参数，刷新upgrade_param.json文件
        if upgrade_new_param and not self.fresh_new_param(upgrade_new_param):
            self.print_msg(ERROR, "Failed to fresh upgrade_param.json.")
            self.set_task_data("error", "100")
            return False
        # 创建并启动任务线程
        ipmc_tool_thread = threading.Thread(target=self.ipmc_tool_upgrade_product_secondphase,
                                            args=(__taskmsg, self.plandata_path), name="child-thread-0")
        ipmc_tool_thread.start()
        # 收集任务信息
        ipmc_tool_thread_tasks_data = {
            "upgrade_product": {
                "thread": ipmc_tool_thread, "operation": "Upgrade Product Secondphase", "countdown": 0}}
        # 监控任务进度
        self.monitor_tasks(ipmc_tool_thread_tasks_data, ipmc_tool_start_time, "IPMC")
        if not self.upgrade_product_status:
            time.sleep(5)
            self.set_task_data("error", "100")
            return False
        self.set_task_data("finish", "100")
        return True

    def ipmc_tool_upgrade_product_secondphase(self, task_detail, work_path):
        """
        封装ipmc_tool_upgrade_product调用方法
        """
        status = OperateProductUtil.ipmc_tool_upgrade_product_secondphase(task_detail, work_path)
        if status is False:
            self.upgrade_product_status = False
            return self.upgrade_product_status
        self.upgrade_product_status = True
        return self.upgrade_product_status

    def fresh_new_param(self, upgrade_new_param):
        """
        将二段式新加的参数添加到upgrade_param.json文件中
        :param upgrade_new_param: 新增参数
        :return:
        """
        upgrade_param_json_file = os.path.join(self.plandata_path, 'upgrade_param.json')
        try:
            with os.fdopen(os.open(upgrade_param_json_file, os.O_RDWR, mode=0o600),
                           "r+") as w_stream:
                data = json.loads(w_stream.read())
                data.update(upgrade_new_param)
                w_stream.seek(0)
                w_stream.write(json.dumps(data))
        except Exception as e:
            logger.error(f"Failed to fresh {upgrade_param_json_file}. Error: {e}")
            return False
        return True


def main(argv):
    params = OperateProductUtil.format_params(argv)
    script_id = params.get("script_id")
    e_task_path = os.path.join("/opt/upgrade/easysuite_upgrade/taskmgr", script_id)
    if not OperateProductUtil.is_path_valid(script_id):
        logger.error("script_id %s is invalid" % script_id)
        return False
    params.update({"task_id_path": e_task_path})

    operate_function = OperateproductSecondPhase(params)
    result = operate_function.fresh_omp_json("fresh")
    if not result:
        return False
    targetversion = params.get("des_version")
    # 二段式升级新添加的参数
    upgrade_all_redis = params.get("upgrade_all_redis", "0")
    upgrade_new_param = {"upgradeallredis": upgrade_all_redis} if upgrade_all_redis != "0" else {}
    operate_function.upgrade_product_secondphase(targetversion, e_task_path, upgrade_new_param)
    result = operate_function.fresh_omp_json("recover")
    if not result:
        return False


if __name__ == '__main__':
    main(sys.argv)
