#!/bin/bash
##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

##################################################
# 初始化日志路径和日志文件名
##################################################
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"

# 后台挂起方式执行
function execute_py_suspend()
{
    python "${py_script}" "$@" >>"${LOG_FILE}" 2>&1 &
}

# 主进程阻塞式执行
function execute_py_no_suspend()
{
    python "${py_script}" "$@" >>"${LOG_FILE}" 2>&1
}

function main()
{
    # 加载公共方法
    . "${SCRIPT_PATH}"/common.sh
    check_user || return 1

    # 初始化日志,重入处理日志绕接
    LOG "INFO" "Start to init ${LOG_FILE}."
    LOG "INFO" "Input:$*"

    # 加载平台证书环境变量
    export SSL_ROOT=/opt/oss/manager/etc/ssl
    export CIPHER_ROOT=/opt/oss/manager/etc/cipher

    # shellcheck source=common.sh
    . "${CLOUDSOP_PROFILE}" >>"${LOG_FILE}" 2>&1
    # 记录python路径
    LOG "INFO" "Python path:$(which python)."

    # 来源外部环境变量
    [ ! -f "${py_script}" ] && py_script="${py_script}c"
    # py和pyc文件都不存在报错退出
    [ ! -f "${py_script}" ] && return 1

    # shellcheck disable=SC2154
    if [ "${run_type}" == "no-suspend" ]
    then
        #直接执行，不挂起
        execute_py_no_suspend "$@" || return 1
    else
        execute_py_suspend "$@" || return 1
    fi
}

main "$@"
exit $?