#!/bin/bash

##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"

[ ! -d "${LOG_PATH}" ] && mkdir -p "${LOG_PATH}"

# 参数校验
function check_param()
{
	local para=$1
	echo "$para" | grep -q -E '^[ 0-9a-zA-Z./:_-]'
	result=$?
	if [ "$result" -ne 0 ]
	then
        	echo "parameter error!"
        	exit 1
	fi
}

# 初始化参数
function init_param()
{	
	DB_PATH=$1
	check_param "${DB_PATH}" || return 1
	CLONE_DB_PATH=$2
	check_param "${CLONE_DB_PATH}" || return 1
	TMP_FILE=$DB_PATH'/csvfile'
	DB_FILE=$DB_PATH'/easysuite.sqlite3'
	DB_CLONE_FILE=$CLONE_DB_PATH'/easysuite.sqlite3'
}

# 检查脚本执行用户
function check_user()
{
    local user
    user=$(whoami)
    oss_user=$(id -nu 3001)
    if [ "${user}" != "${oss_user}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

# 日志记录
function LOG()
{
    BASH_PID=$$
    if [ "$1" = "ERROR" -o "$1" = "error" ]
    then
        Level="ERROR"
    elif [ "$1" = "WARN" -o "$1" = "warn" ]
    then
        Level="WARN"
    else
        Level="INFO"
    fi
    echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${BASH_PID}] | ${Level} $2" | tee -a ${LOG_FILE}
}

# 迁移数据库数据
function migrate_db()
{
    LOG "INFO" "Start to migrate database"
    clone_db &>>${LOG_FILE}
    result=$?
    LOG "INFO" "Finished to migrate database"
    return ${result}
}

# sql导入导出
function clone_db()
{
	[ ! -d ${TMP_FILE} ] && mkdir ${TMP_FILE} 

	tables=`sqlite3 ${DB_FILE} ".tables"`
	arr=($tables)
	echo "tables: ${tables}"

	sqlite3 ${DB_FILE} &>>${LOG_FILE} <<- EXIT_HERE
	.output ${SCRIPT_PATH}/sqltmp.sql
	.dump 
	.output stdout
	.exit
	EXIT_HERE

	for s in ${arr[@]}
	do
		sqlite3 ${DB_CLONE_FILE} &>>${LOG_FILE} <<- EXIT_HERE
		delete from ${s};
		.exit
		EXIT_HERE
	done
	
	sqlite3 ${DB_CLONE_FILE} &>>${LOG_FILE} <<- EXIT_HERE
	.read ${SCRIPT_PATH}/sqltmp.sql
	.exit
	EXIT_HERE
	rm -f ${SCRIPT_PATH}/sqltmp.sql
}

# 主入口
function main()
{
	check_user || return 1
	init_param "$@" || return 1
	migrate_db
	return $?
}

main "$@"
exit $?
