#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
# File name: es_stop.sh
# Description: the shell to stop root easysuite
# 备注：该脚本仅供EngrWizard微服务管理面部署OM包使用
path=$(cd $(dirname $0);pwd)
log_path=$path'/var/run/log/easysuite.log'
sudobin_pkg_path=$path'/easysuite/plugins/common/NCE-Common/upgrade_online/service/scripts/upgrade_sudo_pkg/sudobin_pkg.tar'

user=$(whoami)
if [ "${user}" != "ossadm" ]
then
    echo "The script must be run as the ossadm user."
    exit 1
fi

# 提权删除root权限的easysuite进程
. /opt/oss/manager/bin/engr_profile.sh
tmp_uuid=$(cat /proc/sys/kernel/random/uuid)
tmp_sudo_path="/opt/tmp_sudo_${tmp_uuid}"
sudo "${SUPER_ROOT}"/execute.sh ${sudobin_pkg_path} ${tmp_sudo_path} kill_root_es.sh >>$log_path
if [ $? -ne 0 ]
then
    echo "Failed to stop root EasySuite server."
    logger -t $USER -p local0.err "Failed to stop root EasySuite server." >/dev/null 2>&1 &
    exit 1
fi

# 删除ossadm权限的easysuite进程
ps_result=`ps -ef | grep 19090 | grep easysuite | awk '{print $2}'`
timestr=`date '+%Y-%m-%d %H:%M:%S'`
if [ -z "${ps_result}" ];then
    echo "no server is running, stop easysuite success."
    exit 0
else
    for i_result in ${ps_result[@]};
    do
        echo "kill pid $i_result"
        kill -9 $i_result
    done
    sleep 2
    ps_kill_result=`ps -ef | grep 19090 | grep easysuite | awk '{print $2}'`
    if [ -z "${ps_kill_result}" ]
    then
        echo "stop easysuite success."
        logger -t $USER -p local0.err "stop easysuite successfully." >/dev/null 2>&1 &
        if [ -f "${log_path}" ]
        then
            echo "[$timestr] user $user stop easysuite success." >>$log_path 2>&1
        fi
    else
        echo "stop easysuite failed."
        logger -t $USER -p local0.err "stop easysuite failed." >/dev/null 2>&1 &
        if [ -f "${log_path}" ]
        then
            echo "[$timestr] user $user stop easysuite failed." >>$log_path 2>&1
        fi
    fi
fi
