#!/bin/bash
# Copyright © Huawei Technologies Co., Ltd. 2019-2020. All rights reserved.
# File name: stop.sh
# Description: the shell to stop easysuite
# 脚本工作路径
path=$(cd $(dirname $0);pwd)
# 脚本日志目录
log_path=${path}'/var/run/log/easysuite.log'
# sudo提权包路径
sudobin_pkg_path=${path}'/easysuite/plugins/common/NCE-Common/upgrade_online/service/scripts/upgrade_sudo_pkg/sudobin_pkg.tar'

################################
# 功能说明:检查脚本执行用户
################################
function check_user()
{
    user=$(whoami)
    if [ "${user}" != "ossadm" ]
    then
        echo "The script must be run as the ossadm user."
        return 1
    fi
}

################################
# 功能说明:检查easysuite进程并停止
################################
function stop_es_process()
{
    # 删除ossadm权限的easysuite进程
    ps_result=`ps -ef | grep ${ES_PORT} | grep easysuite | awk '{print $2}'`
    timestr=`date '+%Y-%m-%d %H:%M:%S'`
    if [ -z "${ps_result}" ];then
        echo "no server is running, stop easysuite success."
        exit 0
    else
        for i_result in ${ps_result[@]};
        do
            echo "kill pid $i_result"
            kill -9 $i_result
        done
        sleep 2
        ps_kill_result=`ps -ef | grep ${ES_PORT} | grep easysuite | awk '{print $2}'`
        if [ -z "${ps_kill_result}" ]
        then
            echo "stop easysuite success."
            logger -t $USER -p local0.err "stop easysuite successfully." >/dev/null 2>&1 &
            if [ -f "${log_path}" ]
            then
                echo "[$timestr] user $user stop easysuite success." >>$log_path 2>&1
            fi
        else
            echo "stop easysuite failed."
            logger -t $USER -p local0.err "stop easysuite failed." >/dev/null 2>&1 &
            if [ -f "${log_path}" ]
            then
                echo "[$timestr] user $user stop easysuite failed." >>$log_path 2>&1
            fi
        fi
    fi
}

################################
# 功能说明:加载公共方法
################################
function load_common()
{
    local current_path="${1}"
    common_file="${current_path}/common.sh"
    [ -f "${common_file}" ] && chmod u+x "${common_file}" && source "${common_file}"
}

################################
# 功能说明:主入口
################################
function main()
{
    # 检查脚本执行用户
    check_user || return $?
    # 加载公共方法
    load_common "${path}"
    # 加载es自定义环境变量
    load_es_env_file "${path}"
    # 停止ES进程
    stop_es_process
}

main "$@"
exit $?



