#!/bin/bash
#get absolute path 
FileName="`basename $0`"
MODULE_NAME="`echo ${FileName} | sed 's/\.sh//g'`"
RELATIVE_PATH="`dirname $0`"

#get absolute path 
cd "${RELATIVE_PATH}"
ABSOLUATELY_PATH=`pwd`
cd -

. ${ABSOLUATELY_PATH}/bin/common.inc


function fn_check_folder_link()
{
    local folder="$1"
    if [ -z "${folder}"  -o ! -d "${folder}" ]  
    then
        echo "Error: The parameter '${folder}' is invalid."
        return 2
    fi

    if [ -L "${folder}" ]
    then
        echo "Error: The folder is a softlink file"
        return 3
    fi

    local abs_path=`readlink -m "${folder}"`
    local file_path=`echo "${folder}" | sed -r 's#/+#/#g' | sed 's#/$##'`
    if [ "${abs_path}" != "${file_path}" ]
    then
        echo "Error: The file '${folder}' invalid."
        return 5
    fi
 
    return 0
}


function fn_check_blank()
{
    local param="$1"
    
    #Note: 判断参数中是否包含换行符、制表符
    no_blank_param=$(echo "${param}" | sed ':a;$!N;s/[\n\t\r]//g;ta')
    
    if [ "${param}" != "${no_blank_param}" ]
    then
        echo "Error: The param:<${param}> can not contain <\n|\t|\r>."
        return 5
    fi
    
    return 0
}


function fn_main()
{
    for param in "$@"
    do
        fn_check_blank "${param}" || return $?
    done
    fn_real_main "$@"
    return $?
}

function fn_real_main()
{
    PRINT_LOG "INFO" "Start to install package."
     
    local sudobinpath="$1"
    local install_path="$2"
    if [ -z "${sudobinpath}" ]
    then
        PRINT_LOG "FATAL" "The sudoin path <${sudobinpath}> is empty." &> /dev/null
        return 1
    fi
    
    #Note:Check the sudopin path on sudoers file
    fn_check_folder_link "${sudobinpath}" || return $?
    
    local tmp_ostype=$(bash /usr/local/osconfig/os/bin/getostype.sh)
    #Note:install frame sudobin_pkg
    local sudopkg="${ABSOLUATELY_PATH}/sudobin_pkg.tar"
    local sudopkg_list=$(ls -1 ${ABSOLUATELY_PATH}/sudobin-*_pkg.tar 2> /dev/null)
    for tmp_pkg in ${sudopkg} ${sudopkg_list}
    do
        local os_type=''
        [ -z "$tmp_pkg" ] && continue
        [[ "${tmp_pkg}" =~ sudobin- && ! -z "${tmp_ostype}" ]] && os_type="${tmp_ostype}"
        fn_invoke_sudo_pkg "${sudobinpath}" "${tmp_pkg}" "install.sh" "${os_type}" "${install_path}" || return $?
    done

    PRINT_LOG "INFO" "Install sudo script done."
    
    return 0
}

fn_main "$@"
RET_MAIN=$?
if [[ "$RET_MAIN" == "0" ]]
then
    logger -t $USER -p local0.info "$FileName;Successful;${OPERIP:-127.0.0.1};Excute execution $FileName."
else
    logger -t $USER -p local0.err "$FileName;Failed;${OPERIP:-127.0.0.1};Excute execution $FileName."
fi
[ -f "${TMP_CONTENT_FILE}" ] && rm -f "${TMP_CONTENT_FILE}" &> /dev/null
FUNC_CLEAN_TMP_FILE &> /dev/null
exit ${RET_MAIN}
