#!/bin/bash
set +x

xuser=$(id -un)
if [ "${xuser}" != "arbiter" ]
then
  echo "please login as arbiter, then excute the script again."
  exit 1
fi

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

. ${curPath}/../env/env.properties

. /etc/profile
TMOUT=0


BASE_DIR="${MONITOR_HOME}"
LIB_DIR="${MONITOR_HOME}/lib/"
CONF_DIR="${MONITOR_HOME}/conf/"
LOCAL_JAR=`ls $LIB_DIR | sed "s|^|$LIB_DIR|" | tr '\n' ':'`
JAVA_CP=$CLASSPATH:$LOCAL_JAR
JAVA_MAIN="com.huawei.aamonitor.util.CmdExecutor"
JAVA_OPTS="-Dbase.dir=${BASE_DIR}"
CIPHER_ROOT="${COMMON_HOME}/cipher"

export OSS_ROOT=${BASE_DIR}
export CIPHER_ROOT=${CIPHER_ROOT}

param="-main isetcd $@"

for index in $(seq 1 2)
do
    echo ${param} | ${ARBITRATION_JAVA_HOME}/bin/java $JAVA_OPTS $JAVA_OPTS -cp $JAVA_CP $JAVA_MAIN 2> /dev/null
    RESULT=$?
    if [ ${RESULT} -eq "0" ]
    then
        break
    fi
    sleep 5
done
exit ${RESULT}

