#!/bin/bash
set +x

xuser=$(id -un)
if [ "${xuser}" != "arbiter" ]
then
  echo "please login as arbiter, then excute the script again."
  exit 1
fi

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

. ${curPath}/../env/env.properties

. /etc/profile
TMOUT=0

rootDir=$(echo $(cd "$(dirname "$0")"; pwd))


BASE_DIR="${MONITOR_HOME}"
LIB_DIR="${MONITOR_HOME}/lib/"
CONF_DIR="${MONITOR_HOME}/conf/"
LOCAL_JAR=`ls $LIB_DIR | sed "s|^|$LIB_DIR|" | tr '\n' ':'`
JAVA_CP=$CLASSPATH:$LOCAL_JAR:$CONF_DIR
JAVA_MAIN="com.huawei.aamonitor.util.CmdExecutor"
CIPHER_ROOT="${COMMON_HOME}/cipher"

export MONITOR_ROOT=${BASE_DIR};
export ETCD_ROOT=${ETCD_HOME};
export OSS_ROOT=${BASE_DIR};
export CIPHER_ROOT=${CIPHER_ROOT};
echo -main iscertmgmt -mode create -type monitor | ${ARBITRATION_JAVA_HOME}/bin/java -cp $JAVA_CP $JAVA_MAIN

exit $?