#!/bin/bash
set +x

xuser=$(id -un)
if [ "${xuser}" != "arbiter" ]
then
  echo "please login as arbiter, then excute the script again."
  exit 1
fi

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath
. ${curPath}/../env/env.properties

. /etc/profile
TMOUT=0

BASE_DIR="${MONITOR_HOME}"
LIB_DIR="${BASE_DIR}/lib/"
CONF_DIR="${BASE_DIR}/conf/"
LOCAL_JAR=`ls $LIB_DIR | sed "s|^|$LIB_DIR|" | tr '\n' ':'`
JAVA_CP=$CLASSPATH:$LOCAL_JAR:$CONF_DIR
JAVA_MAIN="com.huawei.aamonitor.util.CmdExecutor"
CIPHER_ROOT="${COMMON_HOME}/cipher"

export MONITOR_ROOT=${BASE_DIR};
export ETCD_ROOT=${ETCD_HOME};
export OSS_ROOT=${BASE_DIR};
export CIPHER_ROOT=${CIPHER_ROOT};
echo "Please input password of ca certificate."
read -s passwd1

repeat_count=3

while [ ${repeat_count} -gt 0 ]
do
  echo "Please input new password of server certificate."
  read -s pwd_server1
  echo "Please input password of server certificate again."
  read -s pwd_server2
  if [ "${pwd_server1}" == "${pwd_server2}" ];then
      break
  fi

  echo
  echo "The two inputs are inconsistent."
  repeat_count=$(echo "${repeat_count} - 1" | bc)

  if [ ${repeat_count} -le 0 ]
  then
      echo "The number of retry times exceeds the maximum [3]. Exit"
      exit 1
  fi

  echo "Retry. Remaining times: ${repeat_count}"
  echo
done

repeat_count=3

while [ ${repeat_count} -gt 0 ]
do
  echo "Please select the length of Key: [2048-3072]"
  read length
  expr ${length} + 0 &>/dev/null
  number_check=$?


  if [ ${number_check} -eq 0  ]
  then
      if [ "${length}" -ge 2048  -a  "${length}" -le 3072 ]
      then
          break
      fi
  fi

  echo
  echo "Invalid input."
  repeat_count=$(echo "${repeat_count} - 1" | bc)

  if [ ${repeat_count} -le 0 ]
  then
      echo "The number of retry times exceeds the maximum [3]. Exit"
      exit 1
  fi
  echo "Retry. Remaining times: ${repeat_count}"
  echo
done

echo "Please input new ca folder: "
read capath
echo -main iscertmgmt -mode replace -type ca -capath "${capath}" -capwd "${passwd1}" -pwd "${pwd_server1}" -pwdLen "${length}" | ${ARBITRATION_JAVA_HOME}/bin/java -cp $JAVA_CP $JAVA_MAIN

# 控制替换后的CA相关证书权限
[ -f "${ETCD_HOME}/ca/ca.cer" ] && chmod 600 ${ETCD_HOME}/ca/ca.cer
[ -f "${ETCD_HOME}/ca/ca.csr" ] && chmod 600 ${ETCD_HOME}/ca/ca.csr
[ -f "${ETCD_HOME}/ca/ca_key.pem" ] && chmod 600 ${ETCD_HOME}/ca/ca_key.pem

exit $?
