#!/bin/bash

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

. ${curPath}/../env/env.properties
ARBITRATION_WATCHDOG_LOG_FILE_PATH="${ARBITTRATION_WATCHDOG_LOG}/arbitration_watchdog.log"

. ${curPath}/public.sh
env_ips=$(get_current_ips)

function check_ntp()
{
    echo "begin to check ntp service ..." >> $ARBITRATION_WATCHDOG_LOG_FILE_PATH
    bash ./common_ntp.sh -cmd show_ntp_status | tee -a $ARBITRATION_WATCHDOG_LOG_FILE_PATH 2>&1

    bash ./common_ntp.sh -cmd ntp_status_track | tee -a $ARBITRATION_WATCHDOG_LOG_FILE_PATH 2>&1
    if [ $? -ne 0 ]
    then
        echo "the ntp server can not connect." | tee -a $ARBITRATION_WATCHDOG_LOG_FILE_PATH
        bash ./common_ntp.sh -cmd start | tee -a $ARBITRATION_WATCHDOG_LOG_FILE_PATH
    fi

    local offset=$(bash ./common_ntp.sh -cmd offset)
    echo "offset: ${offset}" | tee -a $ARBITRATION_WATCHDOG_LOG_FILE_PATH
    if [ $offset -gt 10000000000 ]
    then
        echo "the ntp offset greater then 10s." | tee -a $ARBITRATION_WATCHDOG_LOG_FILE_PATH
        local ntpip=$(bash ./common_ntp.sh -cmd using_server)
        bash ./common_ntp.sh -cmd stop

        sleep 1
        ntpdate $ntpip >> $ARBITRATION_WATCHDOG_LOG_FILE_PATH 2>&1
        sleep 1

        bash ./common_ntp.sh -cmd start
        #wait next circle, systemd will restart this service
    fi

    return 0
}

function init_etcd()
{
    check_ntp

    if [ ! -d $LOG_PATH ]
    then
        mkdir $LOG_PATH
        chown arbiter:ArbiterGroup $LOG_PATH
    fi

    chmod 700 ${ETCD_LOG}/logs
}

function main()
{
    is_aaetcd_started=$(ps -efwww|grep "${ETCD_HOME}/bin/etcd" | grep -v grep)
    is_aamonitor_started=$(ps -efwww|grep "${MONITOR_HOME}/" | grep -v grep)
    etcd_mode=$(cat ${ETCD_HOME}/conf/etcd_server.properties |grep "start.mode" | cut -d "=" -f 2)
    aamonitor_mode=$(cat ${MONITOR_HOME}/conf/aam.properties |grep "start.mode" | cut -d "=" -f 2)


    if [ "${is_aaetcd_started}" == "" ] && [ "${etcd_mode}" == "true" ]
    then
        init_etcd && su - arbiter -s /bin/sh -c "/bin/sh ${ETCD_HOME}/script/service.sh restart >/dev/null 2>&1"
        echo "[$(date "+%Y-%m-%d %H:%M:%S")] Can not find aaetcd, restart aaetcd" >> $ARBITRATION_WATCHDOG_LOG_FILE_PATH
    fi
    
    if [ "${is_aamonitor_started}" == "" ] && [ "${aamonitor_mode}" == "true" ]
    then
        su - arbiter -s /bin/sh -c "/bin/sh ${MONITOR_HOME}/script/service.sh restart >/dev/null 2>&1"
        echo "[$(date "+%Y-%m-%d %H:%M:%S")] Can not find aamonitor, restart aamonitor" >> $ARBITRATION_WATCHDOG_LOG_FILE_PATH
    fi
}

main

