#! /bin/bash

. ./arbitration_opertate_lib
. ./env.properties
. ./public.sh

function get_work_path()
{
    local dir=$(dirname $0)
    local ispointstart=$(echo $dir|awk -F/ '{print $1}')
    if [ "${ispointstart}" = "." ]
    then
        local dir=$(echo ${dir}|sed 's/^.//')
        workfolder="$(pwd)${dir}"
    elif [ "${ispointstart}" = ".." ]
    then
        workfolder="$(pwd)/${dir}"
    else
        workfolder="${dir}"
    fi
}

function create_check_file()
{
    result_code=$1
    echo "#!/bin/bash
echo  RESULT:${result_code} && rm -rf /opt/arbitration_file/check_generate_ca_result.sh
   ">/opt/arbitration_file/check_generate_ca_result.sh

   chmod 500 /opt/arbitration_file/check_generate_ca_result.sh
}

function get_params()
{
    master_omp_node_ip=$1
    master_omp_node_uname=$2
    echo "es_input: master_omp_node_pwd"
    read -s master_omp_node_pwd
    echo "es_input: master_omp_node_ossadm_pwd"
    read -s master_omp_node_ossadm_pwd
    
    slave_omp_node_ip=$3
    slave_omp_node_uname=$4
    echo "es_input: slave_omp_node_pwd"
    read -s slave_omp_node_pwd
    echo "es_input: slave_omp_node_ossadm_pwd"
    read -s slave_omp_node_ossadm_pwd

    # 获取备NCE的common_server节点间通信IP
    slave_inner_comm_ip=$5
    echo "es_input: node_3_root_pwd"
    read -s slave_comm_root_pwd
    master_omp_node_pwd=$(echo ${master_omp_node_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
    master_omp_node_ossadm_pwd=$(echo ${master_omp_node_ossadm_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
    slave_omp_node_pwd=$(echo ${slave_omp_node_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
    slave_omp_node_ossadm_pwd=$(echo ${slave_omp_node_ossadm_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
    slave_comm_root_pwd=$(echo ${slave_comm_root_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
}

function generate_ca()
{
    rm -f /opt/arbitration_file/check_generate_ca_result.sh

    arbitration_log INFO "GENERATE_CA" "Start generate ca."
    [ -d "${ETCD_HOME}/ca" ] && rm -rf "${ETCD_HOME}"/ca/*
    
    # 调用随机数生成随机密码，至少含有一个大写字母、小写字母、数字、特殊字符
    random_password=$(bash ${workfolder}/generate_random_pwd.sh)
    random_password=$(echo ${random_password} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
    
    /usr/bin/expect  << EOF
set timeout 30
spawn su - arbiter -s /bin/sh -c "bash ${ETCD_HOME}/script/init-ca.sh"
expect {
        "please input the value:" {send "${random_password}\r"}
    }

expect eof

EOF

    # 检查是否生成证书
    
    if [ -f "${ETCD_HOME}/ca/ca.cer" ]
    then
        arbitration_log INFO "GENERATE_CA" "Generate ca successfully."
    else
        arbitration_log ERROR "GENERATE_CA" "Generate ca failed."
        $(create_check_file 255)
        exit
    fi
}


function remote_modify_ha()
{
    exec_file="${workfolder}/remote_modify_ha.sh"
    
    # 修改主站点omp的/opt/oss/share/manager/DRService/configuration/ha.properties 的 etcd_pwd_of_ts 字段密文
    /usr/bin/expect  << EOF >/dev/null 2>&1
set timeout 30
spawn bash ${exec_file} ${master_omp_node_ip} ${master_omp_node_uname} "modify_ha_properties" "etcd_pwd_of_ts"
    expect {
        "please input login password:" {send "${master_omp_node_pwd}\r"}
    }
    
        
    expect {
        "please input ossadm password:" {send "${master_omp_node_ossadm_pwd}\r"}
    }
    
    expect {
        "please input the value:" {send "${random_password}\r"}
    }
    
    expect {
        "*modify properties failed*" { exit 255 }
        "*modify properties successfully*" { exit 100 }
    }

expect eof

catch wait result
exit [lindex $result 3]

EOF
    result_master=$?
    sleep 1

    # 如果已有互信先删除，处理对端重装互信失效的情况
    [ -f /root/.ssh/known_hosts ] && sed -i "/^${slave_inner_comm_ip} /d" /root/.ssh/known_hosts
    [ -f /home/${slave_omp_node_uname}/.ssh/known_hosts ] && sed -i "/^${slave_omp_node_ip} /d" /home/${slave_omp_node_uname}/.ssh/known_hosts
    
    # 修改备站点omp的/opt/oss/share/manager/DRService/configuration/ha.properties 的 etcd_pwd_of_ts 字段密文
    /usr/bin/expect  << EOF >/dev/null 2>&1
set timeout 30
spawn /usr/bin/ssh root@${slave_inner_comm_ip}
expect {
    "*yes/no*" {send "yes\r";exp_continue}
    "*assword:" {send "${slave_comm_root_pwd}\r"}
}
expect {
    "*#" {
        send "bash ${exec_file} ${slave_omp_node_ip} ${slave_omp_node_uname} \"modify_ha_properties\" \"etcd_pwd_of_ts\"\r"
        expect {
            "please input login password:" {send "${slave_omp_node_pwd}\r"}
        }

        expect {
            "please input ossadm password:" {send "${slave_omp_node_ossadm_pwd}\r"}
        }

        expect {
            "please input the value:" {send "${random_password}\r"}
        }

        expect {
            "*modify properties failed*" { exit 255 }
            "*modify properties successfully*" { exit 100 }
        }
    }
}
expect eof

catch wait result
exit [lindex $result 3]

EOF

    result_slave=$?
    if [ ${result_master} -eq 100 ] && [ ${result_slave} -eq 100 ]
    then
        arbitration_log INFO "GENERATE_CA" "Modify ha.properties successfully."
    else
        if [ ${result_master} -ne 100 ]
        then
            arbitration_log ERROR "GENERATE_CA" "Modify master ha.properties failed."
        fi
        if [ ${result_slave} -ne 100 ]
        then
            arbitration_log ERROR "GENERATE_CA" "Modify slave ha.properties failed."
        fi
        $(create_check_file 255)
        exit
    fi
}

get_work_path
if [ $(is_generate_cert) == "true" ]
then
    get_params $*
    generate_ca
    remote_modify_ha
    $(create_check_file 100)
else
    $(create_check_file 100)
fi
