#!/bin/bash

. ./env.properties
function check_package()
{
    ls /opt/arbitration_file/arbitration-common*.zip > /dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "No arbitration-common.zip found. Skip."
        return 1
    fi
    ls /opt/arbitration_file/arbitration-monitor*.zip > /dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "No arbitration-monitor.zip found. Skip."
        return 1
    fi
    ls /opt/arbitration_file/arbitration-etcd*.zip > /dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "No arbitration-etcd.zip found. Skip."
        return 1
    fi
}

# 初始化
function init(){
    check_package || return 0
    # 兼容老版本卸载
    if [ "${INDEX}" = "0" ];then
        rpm -qa | grep arbitration | xargs -r rpm -e 2>/dev/null
    fi
    unzip_common || return 1
    unzip_etcd || return 1
    unzip_monitor || return 1
    save_install_home || return 1
    mkdir -p ${ARBITRATION_LOG}
    chown -R arbiter /var/log/arbitration
    chmod 750 /var/log/arbitration
    chmod 750 ${ARBITRATION_LOG}
}

function unzip_etcd(){
    rm -rf ${ETCD_HOME}
    unzip /opt/arbitration_file/arbitration-etcd*.zip -d ${ETCD_HOME} > /dev/null
    cd ${ETCD_HOME}
    chmod 750 .
    chmod 750 *
    chmod 600 conf/*
    chmod 550 bin/*
    chmod 550 script/*
    chmod 640 conf/arbitration-etcd-rsyslog.conf
    chown arbiter: ${ETCD_HOME} -R
    rm -rf ${ETCD_LOG}
    mkdir -p ${ETCD_LOG}
    chmod 750 ${ETCD_LOG_BASE}
    chmod 750 ${ETCD_LOG}
    chown arbiter: ${ETCD_LOG_BASE} -R
}

function unzip_monitor(){
    rm -rf ${MONITOR_HOME}
    unzip /opt/arbitration_file/arbitration-monitor*.zip -d ${MONITOR_HOME} > /dev/null
    cd ${MONITOR_HOME}
    chmod 750 .
    chmod 750 conf/wcc
    chmod 750 lib
    chmod 750 script
    chmod 600 conf/aam.properties
    chmod 600 conf/application.properties
    chmod 600 conf/arbitration-monitor.service
    chmod 600 conf/log4j2.xml
    chmod 600 conf/log4j2.sensitive.properties
    chmod 600 conf/version.ini
    chmod 640 conf/wcc/*
    chmod 550 lib/*
    chmod 550 script/*
    chmod 700 conf
    chown arbiter: ${MONITOR_HOME} -R
    rm -rf ${MONITOR_LOG}
    mkdir -p ${MONITOR_LOG}
    chmod 750 ${MONITOR_LOG_BASE}
    chmod 750 ${MONITOR_LOG}
    chown arbiter: ${MONITOR_LOG_BASE} -R
}

function unzip_common(){
    rm -rf ${COMMON_HOME}
    unzip /opt/arbitration_file/arbitration-common*.zip -d ${COMMON_HOME} > /dev/null
    cd ${COMMON_HOME}
    chmod 750 .
    chmod 750 conf
    chmod 750 foss
    chmod 750 script
    chmod 750 /etc/sysctl.d/
    chmod 640 conf/*
    chmod 640 foss/*
    chmod 750 script/*
    chmod 640 conf/arbitration-common-sysctl.conf
    chmod 700 cipher
    chmod 600 cipher/*
    chmod 600 conf/*
    touch /etc/rc.d/rc.local
    chmod u+x /etc/rc.d/rc.local
    [ -e ${COMMON_HOME}/script/setup.sh ] && ${COMMON_HOME}/script/setup.sh
    chown arbiter: ${COMMON_HOME} -R
}

# 保存安装目录
function save_install_home(){
    write_properties ${ETCD_HOME}/env
    write_properties ${MONITOR_HOME}/env
    write_properties ${COMMON_HOME}/env
}

# 写入配置文件
function write_properties(){
    path=$1
    rm -rf ${path}/env.properties
    mkdir -p ${path}
    cp -f /opt/arbitration_file/env.properties ${path}/env.properties

    chown arbiter: ${path} -R
    chmod 750 ${path}
    chmod 640 ${path}/env.properties
}

function main(){
    init $* || return 1
}

main $*
if [ $? -ne 0 ];then
    echo "arbitration_install failed" >&2
    exit 1
fi

