#!/bin/bash

. ./arbitration_opertate_lib
. ./env.properties
. ./public.sh
. /opt/arbitration_file/config/installEnv.properties

function create_check_file()
{
    result_code=$1
    echo "#!/bin/bash
echo  RESULT:${result_code} && rm -rf /opt/arbitration_file/check_backup_restore_drconfig.sh
   ">/opt/arbitration_file/check_backup_restore_drconfig.sh

   chmod 500 /opt/arbitration_file/check_backup_restore_drconfig.sh
}


# 登录OMP节点，执行OMP上执行相关脚本
function remote_exec()
{
    ${EXPECT} << ENF >/dev/null 2>&1
spawn /usr/bin/ssh ${login_user_name}@${omp_ip_address}
expect {
    "*yes/no*" {send "yes\r";exp_continue}
    "*assword:" {send "${login_user_pwd}\r"}
}

expect {
    "*${login_user_name}@*" {
                            send "su - ossadm\r"
                            expect {
                                "*yes/no*" {send "yes\r";exp_continue}
                                "*assword:" {send "${ossadm_user_pwd}\r"}
                            }

                            expect {
                                "*ossadm@*" {
                                    send "bash /opt/oss/manager/apps/DRService/shscript/modify_ha.sh ${operation_type} ${backup_dir}\r"

                                    expect {
                                        "*modify ha failed*" { exit 255 }
                                        "*modify ha successfully*" { exit 100 }
                                    }
                                }
                            }

                            expect {
                                "*ossadm@*" {send "exit\r"}
                            }

    }
}

expect {
    "*${login_user_name}@*" {send "exit\r"}
}

expect eof

catch wait result
exit [lindex $result 3]

ENF
    result=$?

    if [ ${result} -ne 100 ]
    then
        arbitration_log ERROR "BACKUP_RESTORE_CONFIG" "${operation_type} ha config failed."
        return 255
    else
        arbitration_log INFO "BACKUP_RESTORE_CONFIG" "${operation_type} ha config successfully."
    fi
    return 0
}

function init() {
    echo "es_input: master_omp_node_uname"
    read master_login_user_name
    echo "es_input: master_omp_node_pwd"
    read -s master_login_user_pwd
    echo "es_input: master_omp_node_ossadm_pwd"
    read -s master_ossadm_user_pwd
    echo "es_input: node_1_root_pwd"
    read -s master_commonservice_root_pwd

    echo "es_input: slave_omp_node_uname"
    read slave_login_user_name
    echo "es_input: slave_omp_node_pwd"
    read -s slave_login_user_pwd
    echo "es_input: slave_omp_node_ossadm_pwd"
    read -s slave_ossadm_user_pwd
    echo "es_input: node_3_root_pwd"
    read -s slave_commonservice_root_pwd

    if [ "${site_role}" = "-master" ]
    then
        login_user_name=${master_login_user_name}
        login_user_pwd=${master_login_user_pwd}
        ossadm_user_pwd=${master_ossadm_user_pwd}
        commonservice_root_pwd=${master_commonservice_root_pwd}
    else
        login_user_name=${slave_login_user_name}
        login_user_pwd=${slave_login_user_pwd}
        ossadm_user_pwd=${slave_ossadm_user_pwd}
        commonservice_root_pwd=${slave_commonservice_root_pwd}
    fi

    login_user_pwd=$(echo ${login_user_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
    ossadm_user_pwd=$(echo ${ossadm_user_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
    commonservice_root_pwd=$(echo ${commonservice_root_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
}

function get_omp_maintaince_ip()
{
    arbitration_log INFO "BACKUP_RESTORE_DR_CONFIG" "Start to get the OMP maintenance IP address."
    omp_maintaince_ip=$(su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh;ipmc_adm -cmd statusapp -app DRService -tenant manager -nodeip global |grep -w 'DRService' | sed -n '1p'| awk '{print \$6}'")
    arbitration_log INFO "BACKUP_RESTORE_DR_CONFIG" "Success to get the OMP maintenance IP address is ${omp_maintaince_ip}."
    echo ${omp_maintaince_ip}
}

###################################################################
#
#
#    安装或升级仲裁软件中临时解压一个python路径
#
#
###################################################################
function unzip_temp_python() {
    ARBITRATION_TEMP_PATH=/opt/arbitration_file/arbitration_temp
    rm -rf ${ARBITRATION_TEMP_PATH}
    unzip /opt/arbitration_file/arbitration-common*.zip -d ${ARBITRATION_TEMP_PATH} > /dev/null
    cd ${ARBITRATION_TEMP_PATH}/foss/
    unzip python.zip > /dev/null
    TEMP_ARBITRATION_PYTHON_HOME=${ARBITRATION_TEMP_PATH}/foss/bin/python
    chmod -R 750 ${TEMP_ARBITRATION_PYTHON_HOME}
}

function main() {
    arbitration_log INFO "BACKUP_RESTORE_DR_CONFIG" "start to run backup or restore the dr config"
    rm -rf /opt/arbitration_file/check_backup_restore_drconfig.sh
    unzip_temp_python

    site_role=$1
    omp_ip_address=$2
    local_ip_address=$3
    operation_type=$4
    backup_dir=$5
    arbitration_log INFO "BACKUP_RESTORE_DR_CONFIG" "the operation type is ${operation_type}"
    # 根据用户输入的omp节点IP获取maintaince IP
    omp_ip_address=$(get_omp_maintaince_ip)
    arbitration_log INFO "BACKUP_RESTORE_DR_CONFIG" "Get the OMP maintenance IP address: ${omp_ip_address}"
    EXPECT=/usr/bin/expect
    init
    for i in {1..3}
    do
        remote_exec
        remote_exec_result=$?
        if [ ${remote_exec_result} -eq 0 ]
        then
            break
        fi
        arbitration_log INFO "BACKUP_RESTORE_DR_CONFIG" "retry to modify remote ha properties"
        sleep 1
    done

    if [ ${remote_exec_result} -eq 0 ]
    then
        $(create_check_file 100)
        [ -d ${ARBITRATION_TEMP_PATH} ] && rm -rf ${ARBITRATION_TEMP_PATH}
        return 0
    else
        $(create_check_file 255)
        return 1
    fi
}

main $@
