#!/bin/bash

#################################################
#
# 获取当前环境使用的NTP的类型
# return
#   0 --- ntpd
#   1 --- chronydd
#
#################################################
function _get_ntp_type()
{
    if [ -f ./ntpType ]
    then
        grep chronyd ./ntpType &>/dev/null
        if [ $? -eq 0 ]
        then
            echo "ntp type: chronyd"
            return 1
        fi
        grep ntpd ./ntpType &>/dev/null
        if [ $? -eq 0 ]
        then
            echo "ntp type: ntpd"
            return 0
        fi
    fi
    if [ -f /opt/oss/manager/etc/sysconf/ntpType.flag ]
    then
        su - ossadm -c "grep chrony /opt/oss/manager/etc/sysconf/ntpType.flag" &>/dev/null
        if [ $? -eq 0 ]
        then
            echo "ntp type: chronyd"
            echo chronyd > ./ntpType
            return 1
        else
            echo "ntp type: ntpd"
            echo ntpd > ./ntpType
            return 0
        fi
    fi
    systemctl status chronyd | grep "Active" | grep "running" &>/dev/null
    if [ $? -eq 0 ];then
        echo "ntp type: chronyd"
        echo chronyd > ./ntpType
        return 1
    fi
    systemctl status ntpd | grep "Active" | grep "running" &>/dev/null
    if [ $? -eq 0 ];then
        echo "ntp type: ntpd"
        echo ntpd > ./ntpType
        return 0
    fi
    systemctl status chronyd &>/dev/null
    if [ $? -eq 0 ];then
        echo "ntp type: chronyd"
        echo chronyd > ./ntpType
        return 1
    fi

    echo "ntp type: ntpd"
    echo ntpd > ./ntpType
    return 0
}

function check_ntp_status()
{
    echo "start to check ntp status"
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd ntp_status
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd ntp_status
        return $?
    fi
}

function check_ntp_track()
{
    echo "start to check ntp tracking"
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd ntp_track
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd ntp_track
        return $?
    fi
}

function check_ntp_status_and_track()
{
    check_ntp_status || return 1
    check_ntp_track || return 1
}

function get_ntp_offset()
{
    _get_ntp_type &>/dev/null
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd offset
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd offset
        return $?
    fi
}

function start_ntp()
{
    echo "start to start ntp"
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd start
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd start
        return $?
    fi
}

function stop_ntp()
{
    echo "start to stop ntp"
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd stop
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd stop
        return $?
    fi
}

function restart_ntp()
{
    echo "start to restart ntp"
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd restart
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd restart
        return $?
    fi
}

function enable_ntp()
{
    echo "start to enable ntp"
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd enable
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd enable
        return $?
    fi
}

function add_server()
{
    echo "start to add server"
    local activeIp=$1
    local standbyIp=$2
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        if [ -f ./ntpd_modify_util.sh ]
        then
            bash ./ntpd_modify_util.sh -cmd add_server -active ${activeIp} -standby ${standbyIp}
            return $?
        else
            echo "add server is not allowed."
            return 1
        fi
    elif [ $? -eq 1 ]
    then
        if [ -f ./chronyd_modify_util.sh ]
        then
            bash ./chronyd_modify_util.sh -cmd add_server -active ${activeIp} -standby ${standbyIp}
            return $?
        else
            echo "add server is not allowed."
            return 1
        fi
    fi
}

function clear_server()
{
    echo "start to clear server"
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        if [ -f ./ntpd_modify_util.sh ]
        then
            bash ./ntpd_modify_util.sh -cmd clear_server
            return $?
        else
            echo "clear server is not allowed."
            return 1
        fi
    elif [ $? -eq 1 ]
    then
        if [ -f ./chronyd_modify_util.sh ]
        then
            bash ./chronyd_modify_util.sh -cmd clear_server
            return $?
        else
            echo "clear server is not allowed."
            return 1
        fi
    fi
}

function backup()
{
    _get_ntp_type
    if [ $? -eq 0 ]
    then
        bash ./ntpd_modify_util.sh -cmd backup
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_modify_util.sh -cmd backup
        return $?
    fi
}

function using_server()
{
    check_ntp_status_and_track &>/dev/null || return 1
    _get_ntp_type &>/dev/null
    if [ $? -eq 0 ]
    then
        bash ./ntpd_util.sh -cmd using_server
        return $?
    elif [ $? -eq 1 ]
    then
        bash ./chronyd_util.sh -cmd using_server
        return $?
    fi
}

function main()
{
    for i in {1..3}
    do
        [[ ${1#-} == "cmd" ]] && { cmd=$2; shift 2; }
        [[ ${1#-} == "active" ]] && { active=$2; shift 2; }
        [[ ${1#-} == "standby" ]] && { standby=$2; shift 2; }
    done
    if [ "${cmd}" == "ntp_status" ]
    then
        check_ntp_status
        return $?
    elif [ "${cmd}" == "ntp_track" ]
    then
        check_ntp_track
        return $?
    elif [ "${cmd}" == "ntp_status_track" ]
    then
        check_ntp_status_and_track
        return $?
    elif [ "${cmd}" == "offset" ]
    then
        get_ntp_offset
        return $?
    elif [ "${cmd}" == "start" ]
    then
        start_ntp
        return $?
    elif [ "${cmd}" == "stop" ]
    then
        stop_ntp
        return $?
    elif [ "${cmd}" == "restart" ]
    then
        restart_ntp
        return $?
    elif [ "${cmd}" == "enable" ]
    then
        enable_ntp
        return $?
    elif [ "${cmd}" == "add_server" ]
    then
        add_server ${active} ${standby}
        return $?
    elif [ "${cmd}" == "clear_server" ]
    then
        clear_server
        return $?
    elif [ "${cmd}" == "backup" ]
    then
        backup
        return $?
    elif [ "${cmd}" == "using_server" ]
    then
        using_server
        return $?
    fi
}

main $@
exit $?