#! /bin/bash
. ./arbitration_opertate_lib
. ./env.properties
. ./public.sh
env_ips=$(get_current_ips)

third_node_inner_ip=$1
if [[ ${third_node_inner_ip} == "" ]]
then
    arbitration_log ERROR "CHECK INPUT PARAMETER" "third node inner ip is empty."
    exit 0
fi

#记录结果
function create_check_file()
{
    result_code=$1
    echo "#!/bin/bash
echo  RESULT:${result_code} && rm -rf /opt/arbitration_file/check_start_arbitration_result.sh
   ">/opt/arbitration_file/check_start_arbitration_result.sh

   chmod 500 /opt/arbitration_file/check_start_arbitration_result.sh
}

function modify_monitor_start_script()
{   
    #修改第三方节点的monitor配置
    local real_node_ip=$(get_real_full_ip ${third_node_inner_ip})
    if [[ $(echo "${env_ips}" | grep -iwF "${real_node_ip}") != "" ]]
    then
        arbitration_log INFO "MODIFY_MONITOR_FILE" "Modify monitor properties."
        sed -i "s/aam.local.etcdservers=*.*.*.*:2390/aam.local.etcdservers=${third_node_inner_ip}:2390/g" ${MONITOR_HOME}/conf/aam.properties
        sed -i "s/if.*opt\/controller\/naas\/deployment\/deployment.inc.*]/if false /" ${MONITOR_HOME}/script/service.sh
    fi
}

function start_etcd_monitor
{
    #启动前停止服务
    ps -efww | grep -w "Dprocess.name=arbitration-monitor_${INDEX}" | grep -v grep | awk '{print $2}' | xargs -r kill -9
    ps ax | grep -i "${ETCD_HOME}/bin/etcd" | grep -v grep | awk '{print $1}' | xargs kill -9

    #停止服务后等待2秒，确保端口已释放
    for i in {1..3}
    do
        #启动etcd
        sleep 2
        su - arbiter -s /bin/sh -c "sh ${ETCD_HOME}/script/service.sh start"
        check_result=$?
        if [[ ${check_result} == "0" ]]
        then
            arbitration_log INFO "START_ETCD" "Start etcd successfully."
            $(create_check_file 100)
            break
        else
            arbitration_log INFO "START_ETCD" "Start etcd failed."
        fi
    done

    if [ ${check_result} -ne 0 ]
    then
        $(create_check_file 255)
        exit
    fi

    #启动monitor
    local real_node_ip=$(get_real_full_ip ${third_node_inner_ip})
    if [[ $(echo "${env_ips}" | grep -iwF "${real_node_ip}") = "" ]]
    then
        for i in {1..3}
        do
            su - arbiter -s /bin/sh -c "sh ${MONITOR_HOME}/script/service.sh start"
            check_result=$?
            if [[ ${check_result} == "0" ]]
            then
                arbitration_log INFO "START_ETCD" "Start monitor successfully."
                $(create_check_file 100)
                break
            else
                arbitration_log INFO "START_ETCD" "Start monitor failed."
            fi
        done
        if [ ${check_result} -ne 0 ]
        then
            $(create_check_file 255)
            exit
        fi
    fi
}

function main()
{
    rm -f /opt/arbitration_file/check_start_arbitration_result.sh
    modify_monitor_start_script
    start_etcd_monitor
}

main