#! /bin/bash

INDEX=$1
function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

function usage()
{
    echo "Usage: bash uninstall_arbitration.sh \${INDEX}"
    echo "The detail arbitration index are as follows."
    echo ""
    bash ${curPath}/query_arbitration.sh
}

function init_index(){
    if [ "${INDEX}" = "" ];then
        usage
        return 1
    fi
    echo ${INDEX} | grep -q '[^0-9]' > /dev/null 2>&1
    if [ $? -eq 0 ];then
        usage
        return 1
    fi

    if [ "${INDEX}" = "0" ];then
        FORMAT_INDEX=
    else
        FORMAT_INDEX=$(echo "_${INDEX}")
    fi
    if [ ! -d "/opt/arbitration-etcd${FORMAT_INDEX}" ];then
        echo "Invalid index: ${INDEX}"
        usage
        return 1
    fi
    bash ${curPath}/query_arbitration.sh -index ${INDEX}
    while true
    do
        echo "Make sure you are ready to uninstall. [Y/N]"
        read select
        if [ "${select}" = "n" -o "${select}" = "N" ];then
            return 1
        elif [ "${select}" = "y" -o "${select}" = "Y" ];then
            return 0
        else
            continue
        fi
    done
}

function uninstall_all()
{
    clean_crontab
    uninstall
    deleteUserAndGroup
}

function clean_crontab()
{
    echo "Clean crontab task."
    ARBITRATION_HOME="/opt/arbitration${FORMAT_INDEX}"
    aamonitor_watchdog_path_format=$(echo "${ARBITRATION_HOME}/script/aamonitor_watchdog.sh" | sed 's/\//\\\//g')
    if [[ -e /etc/SuSE-release ]]
    then
        sed -i "/${aamonitor_watchdog_path_format}/d" /etc/crontab
        service cron restart > /dev/null
    elif [ -e /etc/euleros-release ]
    then
        sed -i "/${aamonitor_watchdog_path_format}/d"  /etc/crontab
        systemctl restart crond.service > /dev/null
    else
        sed -i "/${aamonitor_watchdog_path_format}/d"  /var/spool/cron/root
    fi
}

function deleteUserAndGroup()
{
    echo "Delete arbitration user."
    # ٲĿ¼УɾûֹӰٲ
    ls /opt | grep arbitration-etcd > /dev/null 2>&1
    if [ $? -eq 0 ];then
        echo "Skip delete arbitration user."
        return 0
    fi
    userdel -rf arbiter > /dev/null 2>&1
    grep ArbiterGroup /etc/group > /dev/null
    if [[ $? == "0" ]]
    then
        groupdel ArbiterGroup
    fi
}

#жǰ
function pre_uninstall()
{
    init_index || return 1
}

function uninstall()
{
    echo "Stop arbitration process."
    ps -ef | grep -w "Dprocess.name=arbitration-monitor${FORMAT_INDEX}" | grep -v grep | awk '{print $2}' | xargs -r kill -9 > /dev/null 2>&1
    if [ "${INDEX}" = "0" ];then
        ps -ef | grep -Ew "Dprocess.name=arbitration-monitor|Dprocess.name=arbitration-monitor_${INDEX}" | grep -v grep | awk '{print $2}' | xargs -r kill -9 > /dev/null 2>&1
    fi
    ps -ef | grep -w arbitration-etcd${FORMAT_INDEX} | grep -v grep | awk '{print $2}' | xargs -r kill -9 > /dev/null 2>&1
    if [ "${INDEX}" = "0" ];then
        ps -ef | grep -w arbitration-etcd | grep -v grep | awk '{print $2}' | xargs -r kill -9 > /dev/null 2>&1
    fi
    # indexΪ0ʱrpmв鵽ٲִжأϰ汾
    if [ ${INDEX} -eq 0 ];then
        rpm -qa | grep arbitration | xargs -r rpm -e 2>/dev/null
    fi
    rm -rf /opt/arbitration-etcd${FORMAT_INDEX}
    rm -rf /opt/arbitration-monitor${FORMAT_INDEX}
    rm -rf /opt/arbitration-common${FORMAT_INDEX}
    rm -rf /opt/arbitration${FORMAT_INDEX}
    rm -rf /var/log/arbitration/${INDEX}
    rm -rf /var/log/arbitration-monitor/${INDEX}
    rm -rf /var/log/arbitration-etcd/${INDEX}
    # ϰ汾ɾ־ʱɾϰ汾־
    if [ "${INDEX}" = "0" ];then
        rm -rf /var/log/arbitration/etcd
        rm -rf /var/log/arbitration/monitor
        rm -rf /var/log/arbitration-monitor/arbitration-monitor*
        rm -rf /var/log/arbitration-etcd/etcd.log
        rm -rf /var/log/arbitration-etcd/logs/etcd-server.log*
    fi
}

function main()
{
    pre_uninstall || return 1
    echo "Start uninstall arbitration."
    uninstall_all || return 1
}

main
exit $?