#!/bin/bash

set +x

xuser=$(id -un)
if [ "${xuser}" != "arbiter" ]
then
  echo "please login as arbiter, then excute the script again."
  exit 1
fi

function get_work_path()
{
    local dir=$(dirname $0)
    local ispointstart=$(echo $dir|awk -F/ '{print $1}')
    if [ "${ispointstart}" = "." ]
    then
        local dir=$(echo ${dir}|sed 's/^.//')
        workfolder="$(pwd)${dir}"
    elif [ "${ispointstart}" = ".." ]
    then
        workfolder="$(pwd)/${dir}"
    else
        workfolder="${dir}"
    fi
}

get_work_path

read -s -p "please input the value:" random_password
. ${workfolder}/../env/env.properties

. /etc/profile
TMOUT=0

DIR=$(echo "${ETCD_HOME}/ca" | sed 's#\/#\\\/#g')
sed -i "s/^dir.*/dir                    = ${DIR}/g" ${ETCD_HOME}/conf/openssl.conf


BASE_DIR="${MONITOR_HOME}"
LIB_DIR="${BASE_DIR}/lib/"
CONF_DIR="${BASE_DIR}/conf/"
LOCAL_JAR=`ls $LIB_DIR | sed "s|^|$LIB_DIR|" | tr '\n' ':'`
JAVA_CP=${CLASSPATH}:${LOCAL_JAR}:${CONF_DIR}
JAVA_MAIN="com.huawei.aamonitor.util.CmdExecutor"
CIPHER_ROOT="${COMMON_HOME}/cipher"


export MONITOR_ROOT=${BASE_DIR};
export ETCD_ROOT=${ETCD_HOME};
export OSS_ROOT=${BASE_DIR};
export CIPHER_ROOT=${CIPHER_ROOT};
echo -main iscertmgmt -mode create -type initca -pass "${random_password}" | ${ARBITRATION_JAVA_HOME}/bin/java -cp $JAVA_CP $JAVA_MAIN

exit $?

