#!/bin/bash
set +x

. /etc/profile
function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

. ${curPath}/../env/env.properties

TMOUT=0

rootDir=$(echo $(cd "$(dirname "$0")"; pwd))
. $rootDir/logging.sh
LOG_FILE="${ETCD_LOG}/service.log"
LOG_PATH="${ETCD_LOG}/logs"
BIN_FILE="${ETCD_HOME}/bin/etcd"
CONF_FILE="${ETCD_HOME}/conf/etcd_server.properties"
PID_FILE="${ETCD_HOME}/arbitration-etcd.pid"


function do_start()
{
    g_LOG_Info "begin to start arbitration-etcd ..."
    sed  -i 's/start.mode=false/start.mode=true/' $CONF_FILE

    if [ ! -d $LOG_PATH ]; then
        mkdir $LOG_PATH
        chown arbiter:ArbiterGroup $LOG_PATH
    fi

    chmod 700 ${ETCD_LOG}/logs
    /bin/bash ${ETCD_HOME}/script/start_etcd.sh
    count=0
    while true
    do
        count=$(expr ${count} + 1)
        local pid=$(ps -efww | grep "${BIN_FILE}" | grep -v grep | awk '{print $2}')
        if [ "x${pid}" != "x"  ]
        then
            echo $pid > $PID_FILE
            break
        elif [ ${count} -lt 3 ]
        then
            sleep 1
            continue
        else
            g_LOG_Error "query arbitration-etcd process pid failed."
            return 1
        fi
    done
    g_LOG_Info "start arbitration-etcd success."
    #begin to monitor etcd service
    return 0
}

function do_stop()
{
    g_LOG_Info "begin to stop arbitration-etcd ..."
    sed  -i 's/start.mode=true/start.mode=false/' $CONF_FILE
    /bin/bash ${ETCD_HOME}/script/stop_etcd.sh
    
    local pid=$(ps -efww | grep "$BIN_FILE" | grep -v grep | awk '{print $2}')
    if [ "x${pid}" != "x"  ]
    then
        ps ax | grep -i "${ETCD_HOME}/bin/etcd" | grep -v grep | awk '{print $1}' | xargs kill -9
        if [ $? -ne 0 ]
        then
            return 1
        fi
    fi
    
    g_LOG_Info "stop arbitration-etcd success"    
    return 0
}

function do_restart()
{
    g_LOG_Info "begin to restart arbitration-etcd ..."
    
    do_stop
    if [ $? -ne 0 ]
    then
        return 1
    fi
    
    sleep 1
    do_start
    if [ $? -ne 0 ]
    then
        return 1
    fi
    
    g_LOG_Info "restart arbitration-etcd success"    
    return 0
}

case "$1" in
    start)
        echo -n "Starting arbitration-etcd daemon ... "
        do_start
        exit $?
        ;;
    stop)
        echo -n "Stoping arbitration-etcd daemon ... "
        do_stop
        exit $?
        ;;
    restart)
        echo -n "Restarting arbitration-etcd daemon ... "
        do_restart
        exit $?
        ;;
    *)
        echo "Usage: $0 {start|stop|restart}"
        exit 1
        ;;
esac
