#!/bin/bash
xuser=$(id -un)
if [ "${xuser}" != "arbiter" ]
then
  echo "please login as arbiter, then excute the script again."
  exit 1
fi
function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

. ${curPath}/../env/env.properties

LOG_FILE=${ETCD_LOG}/start.log

uname -a | grep aarch64
if [ $? = 0 ];then
        export LD_LIBRARY_PATH=$ARBITRATION_JAVA_HOME/lib/aarch64/server:$LD_LIBRARY_PATH
        export ETCD_UNSUPPORTED_ARCH=arm64
else
    export LD_LIBRARY_PATH=$ARBITRATION_JAVA_HOME/lib/amd64/server:$LD_LIBRARY_PATH
fi

export PATH=$PATH:$ARBITRATION_JAVA_HOME/bin

if [ ! -d "${ETCD_LOG}" ];then
    mkdir -p ${ETCD_LOG}
    result=$?
fi

if [ ! -f "${ETCD_LOG}/etcd.log" ];then
    touch ${ETCD_LOG}/etcd.log
    result=$?
fi

if [ ! -d "${ETCD_LOG}/logs" ];then
    mkdir -p ${ETCD_LOG}/logs
    result=$?
fi

CONFIG_YAML="${ETCD_HOME}/conf/etcd_server.yaml"
CONFIG_PROPERTIES="${ETCD_HOME}/conf/etcd_server.properties"


# update data and log path

chmod 600 ${CONFIG_PROPERTIES}
chmod 600 ${CONFIG_YAML}

nohup ${ETCD_HOME}/bin/etcd --config-file=${CONFIG_YAML} &>${ETCD_LOG}/etcd.log &