#!/bin/bash

xuser=$(id -un)
if [ "${xuser}" != "arbiter" ]
then
  echo "please login as arbiter, then excute the script again."
  exit 1
fi

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

. ${curPath}/../env/env.properties

PID=$(ps ax | grep -i "${ETCD_HOME}/bin/etcd" | grep -v grep | awk '{print $1}')
if [ "${PID}" != "" ];then
  kill -9 $PID
fi

