#! /bin/bash

. ./arbitration_opertate_lib
. ./env.properties
. ./public.sh
env_ips=$(get_current_ips)
#############################################
#
#     所有仲裁节点：格式  node1,node2,node3
#
#############################################
function get_work_path()
{
    local dir=$(dirname $0)
    local ispointstart=$(echo $dir|awk -F/ '{print $1}')
    if [ "${ispointstart}" = "." ]
    then
        local dir=$(echo ${dir}|sed 's/^.//')
        workfolder="$(pwd)${dir}"
    elif [ "${ispointstart}" = ".." ]
    then
        workfolder="$(pwd)/${dir}"
    else
        workfolder="${dir}"
    fi
}

get_work_path

all_arbitration_nodes=$1

if [[ ${all_arbitration_nodes} == "" ]]
then
    old_master_nodes_ips=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep master_nodes_inner_ips|awk -F = '{printf $2}'`
    old_slave_nodes_ips=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep slave_nodes_inner_ips|awk -F = '{printf $2}'`
    old_third_node_ip=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep third_node_inner_ip|awk -F = '{printf $2}'`
    all_arbitration_nodes=$old_master_nodes_ips","$old_slave_nodes_ips","$old_third_node_ip
fi

function get_params()
{
    echo "es_input: master_omp_node_pwd"
    read -s master_omp_node_pwd
    echo "es_input: master_omp_node_ossadm_pwd"
    read -s master_omp_node_ossadm_pwd

    echo "es_input: slave_omp_node_pwd"
    read -s slave_omp_node_pwd
    echo "es_input: slave_omp_node_ossadm_pwd"
    read -s slave_omp_node_ossadm_pwd
}

function create_check_file()
{
    result_code=$1
    echo "#!/bin/bash
echo  RESULT:${result_code} && rm -rf /opt/arbitration_file/check_config_etcd_result.sh
   ">/opt/arbitration_file/check_config_etcd_result.sh

   chmod 500 /opt/arbitration_file/check_config_etcd_result.sh
}

function config_certificate()
{
    [ $(is_generate_cert) == "false" ] && return 100

    LOCAL_NODE_IP=$1
    rm -rf ${ETCD_HOME}/ssl

    # 调用随机数生成随机密码，至少含有一个大写字母、小写字母、数字、特殊字符
    random_password=$(bash ${workfolder}/generate_random_pwd.sh)
    random_password=$(echo ${random_password} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')

    /usr/bin/expect  << EOF
set timeout 30
spawn su - arbiter -s /bin/sh -c "bash ${ETCD_HOME}/script/init-cert.sh ${LOCAL_NODE_IP}"
    expect {
        "please input the value:" {send "${random_password}\r"}
    }

expect eof
EOF

    # 检查是否生成证书
    if [ -f "${ETCD_HOME}/ssl/server.cer" ]
    then
        arbitration_log INFO "CONFIG_ETCD" "Generate server certificate successfully."
        return 100
    else
        arbitration_log ERROR "CONFIG_ETCD" "Generate server certificate failed."
        return 255
    fi
}

function get_omp_maintaince_ip()
{
    arbitration_log INFO "CONFIG_ETCD" "Start to get the OMP maintenance IP address."
    omp_maintaince_ip=$(su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh;ipmc_adm -cmd statusapp -app DRService -tenant manager -nodeip global |grep -w 'DRService' | sed -n '1p'| awk '{print \$6}'")
    arbitration_log INFO "CONFIG_ETCD" "Success to get the OMP maintenance IP address is ${omp_maintaince_ip}."
    echo ${omp_maintaince_ip}
}

function etcd_config
{
    rm -f /opt/arbitration_file/check_config_etcd_result.sh
    all_arbitration_nodes_ip_list=(`echo $all_arbitration_nodes|tr ',' ' '`)
    #获取当前节点角色
    for node_ip in ${all_arbitration_nodes_ip_list[@]}
    do
        real_node_ip=$(get_real_full_ip ${node_ip})
        if [[ $(echo "${env_ips}" | grep -iwF "${real_node_ip}") != "" ]]
        then
            LOCAL_NODE_IP="${node_ip}"
            break
        fi
    done

    arbitration_log INFO "CONFIG_ETCD" "Start config etcd on node:${LOCAL_NODE_IP}."
    if [ ! -d "${ARBITRATION_LOG}/etcd" ];then
        mkdir -p "${ARBITRATION_LOG}/etcd"
        chmod 750 "${ARBITRATION_LOG}/etcd"
    fi

    for i in {1..3}
    do
        config_certificate ${LOCAL_NODE_IP}
        config_certificate_result=$?
        if [ ${config_certificate_result} -eq 100 ]
        then
            break
        fi
        arbitration_log INFO "CONFIG_ETCD" "retry to config certificate"
        sleep 1
    done

    if [ ${config_certificate_result} -ne 100 ]
    then
        arbitration_log ERROR "CONFIG_ETCD" "config certificate failed."
        $(create_check_file 255)
        exit
    else
        arbitration_log INFO "CONFIG_ETCD" "config certificate successfully."
    fi

    #配置etcd
    ${COMMON_HOME}/foss/python/bin/python ${ETCD_HOME}/script/setup.pyc --localapiip ${LOCAL_NODE_IP} --apiips "${all_arbitration_nodes}" --custom

    if [[ $? == "0" ]]
    then
        arbitration_log INFO "CONFIG_ETCD" "Config etcd successfully."
    else
        arbitration_log INFO "CONFIG_ETCD" "Config etcd failed."
        $(create_check_file 255)
        exit
    fi
}

function remote_modify_ha()
{
    exec_file="${workfolder}/remote_modify_ha.sh"

    /usr/bin/expect  << EOF >/dev/null 2>&1
set timeout 30
spawn bash ${exec_file} ${omp_node_ip} ${omp_node_uname} "modify_ha_properties" "etcd_pwd_of_ks"
    expect {
        "please input login password:" {send "${omp_node_pwd}\r"}
    }


    expect {
        "please input ossadm password:" {send "${omp_node_ossadm_pwd}\r"}
    }

    expect {
        "please input the value:" {send "${random_password}\r"}
    }

    expect {
        "*modify properties failed*" { exit 255 }
        "*modify properties successfully*" { exit 100 }
    }

expect eof

catch wait result
exit [lindex $result 3]

EOF

    result=$?

    if [ ${result} -eq 100 ]
    then
        arbitration_log INFO "CONFIG_ETCD" "Modify ha.properties successfully."
    else
        arbitration_log ERROR "CONFIG_ETCD" "Failed to modify the ha.properties file of node ${omp_node_ip}."
        $(create_check_file 255)
        exit
    fi
}

arbitration_log INFO "CONFIG_ETCD" "start to config etcd"
etcd_config

# 当前节点为master的第一个common_service节点时，执行以下代码刷新主站点所有OMP的ha.properties
# 只在master的第一个common_service节点执行一次，其他节点不执行
arbitration_log INFO "CONFIG_ETCD" "is generate cert $(is_generate_cert)"
if [ $(is_generate_cert) == "true" ]
then
    get_params
    if [ "${LOCAL_NODE_IP}" = "${all_arbitration_nodes_ip_list[0]}" ]
    then
        # 获取主站点所有参数
        omp_node_ip=$2
        omp_node_ip=$(get_omp_maintaince_ip)
        omp_node_uname=$3
        # 获取主站点密码，转义特殊字符
        omp_node_pwd=$(echo ${master_omp_node_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
        omp_node_ossadm_pwd=$(echo ${master_omp_node_ossadm_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
        # 本地调用远程OMP的脚本
        remote_modify_ha
    fi

    if [ "${LOCAL_NODE_IP}" = "${all_arbitration_nodes_ip_list[1]}" ]
    then
        # 获取备站点所有参数
        omp_node_ip=$4
        omp_node_ip=$(get_omp_maintaince_ip)
        omp_node_uname=$5
        # 获取备站点密码，转义特殊字符
        omp_node_pwd=$(echo ${slave_omp_node_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
        omp_node_ossadm_pwd=$(echo ${slave_omp_node_ossadm_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
        # 本地调用远程OMP的脚本
        remote_modify_ha
    fi
fi
$(create_check_file 100)

