#!/bin/bash
. ./arbitration_opertate_lib
. ./public.sh
. ./env.properties
env_ips=$(get_current_ips)

LOCAl_NODE_ROLE="third"
LOCAL_NODE_IP=""


function create_check_file()
{
    result_code=$1
    echo "#!/bin/bash
echo  RESULT:${result_code} && rm -rf /opt/arbitration_file/check_config_monitor_result.sh
   ">/opt/arbitration_file/check_config_monitor_result.sh

   chmod 500 /opt/arbitration_file/check_config_monitor_result.sh
}

function modify_monitor_script()
{
    arbitration_log INFO "CONFIG_MONITOR" "Start modify monitor script."
    sed -i "s/if.*opt\/controller\/naas\/deployment\/deployment.inc.*]/if false /" ${MONITOR_HOME}/script/service.sh
}

#############################################
#
#
#   init ip
#
#
#############################################
function init()
{
    master_dc_region=$1
    master_nodes_ips=$2
    slave_dc_region=$3
    slave_nodes_ips=$4
    third_node_ip=$5

    if [[ ${master_dc_region} == "" ]] && [[ ${master_nodes_ips} == "" ]] && [[ ${slave_dc_region} == ""  ]] && [[ ${slave_nodes_ips} == ""  ]] && [[ ${third_node_ip} == "" ]]
    then
        master_dc_region=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep master_location_name|awk -F = '{printf $2}'`
        master_nodes_ips=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep master_nodes_inner_ips|awk -F = '{printf $2}'`
        slave_dc_region=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep slave_location_name|awk -F = '{printf $2}'`
        slave_nodes_ips=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep slave_nodes_inner_ips|awk -F = '{printf $2}'`
        third_node_ip=`cat /opt/backup_arbitration/opt_arbitration/arbitration/conf/arbitration_conf.properties |grep third_node_inner_ip|awk -F = '{printf $2}'`
    fi

    local master_nodes_ip_list=(`echo $master_nodes_ips|tr ',' ' '`)
    for node_ip in ${master_nodes_ip_list[@]}
    do
        real_node_ip=$(get_real_full_ip ${node_ip})
        if [[ $(echo "${env_ips}" | grep -iwF "${real_node_ip}") != "" ]]
        then
            LOCAL_NODE_IP="${node_ip}"
            LOCAl_NODE_ROLE="master"
            break
        fi
    done

    local slave_nodes_ip_list=(`echo ${slave_nodes_ips}|tr ',' ' '`)
    for node_ip in ${slave_nodes_ip_list[@]}
    do
        real_node_ip=$(get_real_full_ip ${node_ip})
        if [[ $(echo "${env_ips}" | grep -iwF "${real_node_ip}") != "" ]]
        then
            LOCAL_NODE_IP="${node_ip}"
            LOCAl_NODE_ROLE="slave"
            break
        fi
    done

    if [ "${LOCAl_NODE_ROLE}" == "third" ]
    then
        real_node_ip=$(get_real_full_ip ${third_node_ip})
        if [[ $(echo "${env_ips}" | grep -iwF "${real_node_ip}") != "" ]]
        then
            LOCAL_NODE_IP="${third_node_ip}"
        fi
    fi

    sed -i "s/aam.mastersite=.*/aam.mastersite=${master_dc_region}/g" "${MONITOR_HOME}"/conf/aam.properties
    arbitration_log INFO "CONFIG_MONITOR" "Local node is ${LOCAl_NODE_ROLE} role."
}

#############################################
#
#
#
#   config monitor
#
#
##
############################################

function config_monitor()
{
    arbitration_log INFO "CONFIG_MONITOR" "Start config arbitration-monitor."
    result=""

    if [ ! -d "${ARBITRATION_LOG}/monitor" ];then
        mkdir -p "${ARBITRATION_LOG}/monitor"
        chmod 750 "${ARBITRATION_LOG}/monitor"
    fi
    if [[ ${LOCAl_NODE_ROLE} == "master" ]]
    then
        ${COMMON_HOME}/foss/python/bin/python ${MONITOR_HOME}/script/setup.pyc --role "${LOCAl_NODE_ROLE}" --localdcserial ${master_dc_region} --localip ${LOCAL_NODE_IP} --localetcdservers ${master_nodes_ips} --remotedcserial ${slave_dc_region} --remoteetcdservers ${slave_nodes_ips} --publicetcdservers ${third_node_ip} --custom
        result=$?
    elif [[ ${LOCAl_NODE_ROLE} == "slave" ]]
    then
        ${COMMON_HOME}/foss/python/bin/python ${MONITOR_HOME}/script/setup.pyc --role "${LOCAl_NODE_ROLE}" --localdcserial ${slave_dc_region} --localip ${LOCAL_NODE_IP} --localetcdservers ${slave_nodes_ips} --remotedcserial ${master_dc_region} --remoteetcdservers ${master_nodes_ips} --publicetcdservers ${third_node_ip} --custom
        result=$?
    else
        ${COMMON_HOME}/foss/python/bin/python ${MONITOR_HOME}/script/setup.pyc --role "${LOCAl_NODE_ROLE}" --localdcserial "public" --localip ${LOCAL_NODE_IP} --localetcdservers ${third_node_ip} --remotedcserial "not_public" --remoteetcdservers "${master_nodes_ips},${slave_nodes_ips}" --publicetcdservers ${third_node_ip} --custom
        result=$?
    fi

    if [[ $result == "0" ]]
    then
        arbitration_log INFO "CONFIG_MONITOR" "Config arbitration-monitor successfully."
        $(create_check_file 100)
    else
        arbitration_log INFO "CONFIG_MONITOR" "Config arbitration-monitor failed."
        $(create_check_file 255)
        exit
    fi
}

function refresh_certificate()
{
    [ $(is_generate_cert) == "false" ] && return 0
    arbitration_log INFO "CONFIG_MONITOR" "Start config arbitration-monitor certificate."
    for i in {1..3}
    do
        su - arbiter -s /bin/sh -c "bash ${MONITOR_HOME}/script/init-cert.sh"
        config_certificate_result=$?
        if [ ${config_certificate_result} -eq 0 ]
        then
            break
        fi
        arbitration_log INFO "CONFIG_MONITOR" "retry to config monitor certificate"
        sleep 1
    done

    if [ ${config_certificate_result} -ne 0 ]
    then
        arbitration_log ERROR "CONFIG_MONITOR" "Config monitor certificate failed."
        $(create_check_file 255)
        exit
    else
        arbitration_log INFO "CONFIG_MONITOR" "Config arbitration-monitor certificate success."
    fi
}

function main()
{
    rm -f /opt/arbitration_file/check_config_monitor_result.sh
    init $@
    refresh_certificate
    config_monitor $@
}

main $@