#! /bin/bash

. ./arbitration_opertate_lib
. ./env.properties
. ./public.sh

function get_work_path()
{
    local dir=$(dirname $0)
    local ispointstart=$(echo $dir|awk -F/ '{print $1}')
    if [ "${ispointstart}" = "." ]
    then
        local dir=$(echo ${dir}|sed 's/^.//')
        workfolder="$(pwd)${dir}"
    elif [ "${ispointstart}" = ".." ]
    then
        workfolder="$(pwd)/${dir}"
    else
        workfolder="${dir}"
    fi
}

function create_check_file()
{
    result_code=$1
    echo "#!/bin/bash
echo  RESULT:${result_code} && rm -rf /opt/arbitration_file/check_sync_ca_result.sh
   ">/opt/arbitration_file/check_sync_ca_result.sh

   chmod 500 /opt/arbitration_file/check_sync_ca_result.sh
}

function sync_ca()
{
    rm -f /opt/arbitration_file/check_sync_ca_result.sh
    
    arbitration_log INFO "SYNC_CA" "Start to copy all the target file."
    
    # 需要拷贝的文件
    ca_cer_name=ca.cer
    ca_key_name=ca_key.pem
    manifest_name=manifest.json
    
    copy_file_array=("${ca_cer_name}" "${ca_key_name}" "${manifest_name}")
    
    # 获取ca证书所在节点IP
    node_1_ip=$1
    # 获取ca证书所在节点用户名密码
    echo "es_input: os_user_root"
    read -s os_user_root
    echo "es_input: node_1_root_pwd"
    read -s node_1_root_pwd

    os_user_root=$(echo ${os_user_root} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
    node_1_root_pwd=$(echo ${node_1_root_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')

    # 创建CA目录
    [ -d "${ETCD_HOME}/ca" ] && rm -rf "${ETCD_HOME}/ca"
    mkdir -p "${ETCD_HOME}/ca"
    chown arbiter:ArbiterGroup "${ETCD_HOME}/ca"
    chmod 700 "${ETCD_HOME}/ca"
    [ -f /root/.ssh/known_hosts ] && sed -i "/^${node_1_ip} /d" /root/.ssh/known_hosts
    # 依次拷贝文件
    for copy_file in ${copy_file_array[@]}
    do
        for i in {1..3}
        do
            remote_copy_file "${node_1_ip}" "${os_user_root}" "${node_1_root_pwd}" "${copy_file}"
            remote_copy_file_result=$?
            if [ ${remote_copy_file_result} -eq 0 ]
            then
                break
            fi
            arbitration_log INFO "SYNC_CA" "retry to copy remote file"
            sleep 1
        done
        if [ ${remote_copy_file_result} -ne 0 ]
        then
            $(create_check_file 255)
            exit 255
        fi
    done

    arbitration_log INFO "SYNC_CA" "Copy all the file successfully."
    $(create_check_file 100)
}

function remote_copy_file()
{
    node_ip=$(scp_ip_convert $1)
    node_root_user=$2
    node_root_pwd=$3
    copy_file_name=$4
    
    target_file="${ETCD_HOME}/ca/${copy_file_name}"
    # 交互式scp拷贝
    /usr/bin/expect  << EOF >/dev/null 2>&1
set timeout 30
spawn scp ${node_root_user}@${node_ip}:/opt/arbitration-etcd/ca/${copy_file_name} ${target_file}
    expect {
        "*yes/no*" {send "yes\r";exp_continue}
        "*assword:" {send "${node_root_pwd}\r"}
    }

expect eof
EOF
    
    # 刷属组和权限
    if [ -f "${target_file}" ]
    then
        chown arbiter:ArbiterGroup ${target_file}
        chmod 600 ${target_file}
        arbitration_log INFO "SYNC_CA" "Copy file ${target_file} from ${node_ip} successfully."
    else
        arbitration_log ERROR "SYNC_CA" "Copy file ${target_file} from ${node_ip} failed."
        return 255
    fi
    return 0
}

get_work_path
if [ $(is_generate_cert) == "true" ]
then
    sync_ca $*
else
    $(create_check_file 100)
fi

