#!/bin/bash
. ./arbitration_opertate_lib
. ./public.sh
env_ips=$(get_current_ips)

all_inner_card_ip_list=""
all_access_ip_list=""
NCE_MANAGE_AGENT_IPMC_PATH="/opt/oss/manager/agent/bin"
# 最大索引为9
MAX_INDEX=9
NEW_VERSION=0
PUBLIC_IP=
INPUT_IPS=
CONF_IPS=
AB_INNER_IPS=
SAME_IPS=
IS_UPGRADE=0

###################################################################
#
#
#    安装或升级仲裁软件中临时解压一个python路径
#
#
###################################################################
function unzip_temp_python(){
    ARBITRATION_TEMP_PATH=/opt/arbitration_file/arbitration_temp
    rm -rf ${ARBITRATION_TEMP_PATH}
    unzip /opt/arbitration_file/arbitration-common*.zip -d ${ARBITRATION_TEMP_PATH} > /dev/null
    cd ${ARBITRATION_TEMP_PATH}/foss/
    unzip python.zip > /dev/null
    TEMP_ARBITRATION_PYTHON_HOME=${ARBITRATION_TEMP_PATH}/foss/bin/python
    chmod -R 750 ${TEMP_ARBITRATION_PYTHON_HOME}
}

###########################################################################################
#
#
#       老版本由于使用cron，导致/var/spool/clientmqueue爆满而升级仲裁节点操作系统失败
#       升级仲裁软件的时候，删除/var/spool/clientmqueue下的文件
#
#
###########################################################################################
function clear_arb_inode_backstage()
{
    find /var/spool/clientmqueue/ -type f -exec egrep -l "arbitration" {} \; | xargs rm -f
    find /var/spool/clientmqueue/ -type f -exec egrep -l "check_IO_status" {} \; | xargs rm -f
}

function clear_arb_inode()
{
    local fun_name=CLEAR_ARB_INODE
    arbitration_log INFO "${fun_name}" "start to clean inode"
    local threshold="90"
    local var_inode_percent=$(df -i | grep var$ | awk '{print int($5)}')
    if [ "${var_inode_percent}" -gt "${threshold}" ]
    then
        echo "The inode usage rate on the arbitration node exceeds 90%. Clearing..."
        arbitration_log INFO "${fun_name}" "The inode usage rate on the arbitration node exceeds 90%. Clearing..."
        export -f clear_arb_inode_backstage
        nohup bash -c clear_arb_inode_backstage </dev/null &>/dev/null &
        sleep 30
    fi
    arbitration_log INFO "${fun_name}" "end to clean inode"
}

###################################################################
#
#
#    初始化参数
#
#
###################################################################
function init()
{
    clear_arb_inode
    all_inner_card_ips=$1
    all_access_ips=$2
    master_location_name=$3
    slave_location_name=$4
    master_inner_card_ips=$5
    slave_inner_card_ips=$6
    third_inner_card_ip=$7

    all_inner_card_ip_list=($(echo ${all_inner_card_ips} | tr ',' ' '))
    all_access_ip_list=($(echo ${all_access_ips} | tr ',' ' '))
    master_inner_card_ip_list=($(echo ${master_inner_card_ips} | tr ',' ' '))
    slave_inner_card_ip_list=($(echo ${slave_inner_card_ips} | tr ',' ' '))
    INPUT_IPS=$(echo "${master_inner_card_ip_list[@]} ${slave_inner_card_ip_list[@]} ${third_inner_card_ip}")
    AB_INNER_IPS=$(echo "${master_inner_card_ip_list[@]} ${slave_inner_card_ip_list[@]}")
    PUBLIC_IP=${third_inner_card_ip}

    # 解压临时python路径，安装、升级过程中使用
    unzip_temp_python
}

###################################################################
#
#
#       校验内部通信ip是否
#
#
###################################################################
function check_inner_card_ip()
{
    local fun_name="CHECK_CONFIG_IP"
    arbitration_log INFO "${fun_name}" "Start check configured ip."
    #校验节点内部通信ip及连接地址是对应的
    for ((i=0;i<${#all_access_ip_list[@]};i++))
    do
        num=0
        access_ip="${all_access_ip_list[i]}"
        inner_ip="${all_inner_card_ip_list[i]}"
        real_access_ip=$(get_real_full_ip "${access_ip}")
        real_inner_ip=$(get_real_full_ip "${inner_ip}")

        if [[ $(echo "${env_ips}" | grep -iwF "${real_access_ip}") != "" ]] && [[ $(echo "${env_ips}" | grep -iwF "${real_inner_ip}") != "" ]]
        then
            num=$(($num+1))
            break
        fi
    done
    if [[ "${num}" != "1" ]]
    then
        echo "The local node's inner ip is wrong." >&2
        return 1
    fi

    # 检查输入IP是否是浮动IP
    local float_ip_list=""
    ip addr | grep -w "inet ${real_access_ip}" | egrep "eth[0-9]+:[0-9]+" > /dev/null 2>&1 && float_ip_list="${float_ip_list}${real_access_ip}(Communication IP Address) "
    ip addr | grep -w "inet ${real_inner_ip}" | egrep "eth[0-9]+:[0-9]+" > /dev/null 2>&1 && float_ip_list="${float_ip_list}${real_access_ip}(Access IP Address) "
    if [[ "${float_ip_list}" != "" ]];then
      echo "The ip address ${float_ip_list}is float ip, please modify your input." >&2
      return 1
    fi

    arbitration_log INFO "${fun_name}" "Check configured ip successfully."
}

###################################################################
#
#
#       校验站点名称是否相同
#
#
###################################################################
function check_location_name()
{
    if [[ ${master_location_name} == ${slave_location_name} ]]
    then
        echo "error_location_name,the master_location_name can't be the same as slave_location_name" >&2
        return 1
    fi

    # 校验站点名称只包含字母、数字、-_   ，且长度在1-32
    $(check_location_single ${master_location_name}) || exit 1
    $(check_location_single ${slave_location_name}) || exit 1
}

function check_location_single()
{
    site_name=$1
    local length=$(echo "${site_name}" | wc -L)
    if [[ ${length} -le 0 ]] || [[ ${length} -gt 32 ]]
    then
        $(echo_location_name_not_match)
        return 1
    fi

    echo "${site_name}" | grep -e "[^a-zA-Z0-9_--]" > /dev/null 2>&1
    if [ $? -eq 0 ]
    then
        $(echo_location_name_not_match)
        return 1
    fi
}

function echo_location_name_not_match()
{
    echo "Site name \"${site_name}\" is not valid. The site name can contain one to 32 characters, including uppercase letters, lowercase letters, digits, and special characters _-." >&2
}

# 校验仲裁节点间的连通性
function check_arbitration_connect()
{
    for node_ip in ${all_inner_card_ip_list[@]}
    do
        echo "${node_ip}" | grep ":" &>/dev/null
        if [[ $? -eq 0 ]]
        then
            ping6 -c 2 ${node_ip} &>/dev/null
        else
            ping -c 2 ${node_ip} &>/dev/null
        fi
        if [[ $? -eq 0 ]]
        then
            echo "${node_ip} is up" >> /opt/arbitration_file/check_arbitration_result.sh
        else
            local check_connect_pyscript=/opt/arbitration_file/check_arbitration_connect.pyc
            ${TEMP_ARBITRATION_PYTHON_HOME} "${check_connect_pyscript}" "${node_ip}"
            if [ $? -eq 0 ]
            then
                arbitration_log INFO "check_arbitration_connect" "${node_ip} is up"
            else
                arbitration_log ERROR "check_arbitration_connect" "${node_ip} is down"
                echo "${node_ip} is down" >&2
                return 1
            fi
        fi
    done
}

###########################################################################
#
#
#       校验主备站点是否已安装nce版本
#
#
#
###########################################################################
function check_master_slave_already_install()
{
    local fun_name="CHECK_MASTER_SALVE_ALREADY_INSTALL"
    arbitration_log INFO "${fun_name}" "Start check whether already install nce."
    all_master_slave_nodes_list=(${master_inner_card_ip_list[@]} ${slave_inner_card_ip_list[@]})
    real_third_inner_card_ip=$(get_real_full_ip ${third_inner_card_ip})
    if [[ $(echo "${env_ips}" | grep -iwF "${real_third_inner_card_ip}") == "" ]]
    then
        arbitration_log INFO "${fun_name}" "Not third site node, need to check whether install version."
        su - ossadm -c ". $NCE_MANAGE_AGENT_IPMC_PATH/engr_profile.sh;sh $NCE_MANAGE_AGENT_IPMC_PATH/ipmc_adm -cmd statusapp" >/dev/null 2>&1
        if [[ "$?" != "0" ]]
        then
            echo "The node hasnot installed nce version, you should install nce version before install arbitration software." >&2
            return 1
        fi
    else
        arbitration_log INFO "${fun_name}" "Third site node, no need to check whether install version."
    fi
}

# 检查当前节点是否已安装的仲裁软件，仅在三方站点执行
# return 0：找到了完全匹配的目录，安装和升级场景均使用此目录
# return 1：找到了部分匹配的目录，安装场景直接报错；升级场景继续往下走
# return 2：未找到匹配的目录，安装场景直接新增目录；升级场景直接报错
# return 3: 无目录
function check_installed(){
    ls /opt | grep arbitration-etcd > /dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "0"
        return 3
    fi
    # 遍历环境上的仲裁软件，判断是否是已安装场景
    for check_installed_item in $(ls /opt)
    do
        echo "${check_installed_item}" | grep arbitration-etcd > /dev/null 2>&1
        if [ $? -eq 0 ];then
            aam_properties=/opt/"${check_installed_item}"/conf/etcd_server.yaml
            if [ -f "${aam_properties}" ];then
                NEW_VERSION=1
            else
                aam_properties=/opt/"${check_installed_item}"/conf/etcd_server.properties
                NEW_VERSION=0
                ls ${aam_properties} > /dev/null 2>&1
                if [ $? -ne 0 ];then
                    continue;
                fi
            fi

            current_index=$(get_index_from_path ${check_installed_item})
            get_ip_from_aam_conf "${aam_properties}"
            check_ip_include
            result=$?

            if [ ${result} -eq 0 ];then
                echo "${current_index}"
                return 0
            elif [ ${result} -eq 1 ];then
                echo "Internal IP \"${SAME_IPS}\" has been used in \"${CONF_IPS}\"." >&2
                arbitration_log INFO "Internal IP has been used in \"${CONF_IPS}\"."
                return 1
            elif [ ${result} -eq 2 ];then
                continue
            elif [ ${result} -eq 3 ];then
                # 安装失败的INDEX，需要判断是否有IP完全一致的INDEX
                if [ -z ${temp_index} ]
                then
                    local temp_index=${current_index}
                fi
            fi
        fi
    done
    if [ ! -z ${temp_index} ]
    then
        echo ${temp_index}
        return 0
    fi
    return 2
}

# 根据etcd安装路径获取仲裁软件索引
function get_index_from_path(){
    path=$1
    echo "${path}" | grep "_" > /dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "0"
        return 0
    fi
    index=$(echo "${path}" | sed "s/arbitration-etcd_//g")
    echo "${index}"
    return 0
}

# 获取下一个可以安装的目录
# 0: 已找到可以安装的目录INDEX，回显为待安装的index
# 1: 仲裁软件已满，无法再次安装
function get_install_index(){
    for get_install_index_item in $(seq 0 ${MAX_INDEX})
    do
        if [ ${get_install_index_item} -eq 0 ];then
            index=
        else
            index="_${get_install_index_item}"
        fi

        if [ ! -d /opt/arbitration-etcd${index} ];then
            echo "${get_install_index_item}"
            return 0
        fi
    done
    echo "Already install $(expr ${MAX_INDEX} + 1) arbitration softwares." >&2
    return 1
}

# 初始化将要安装的仲裁软件的索引。NCE端的仲裁软件索引始终为0
function init_index(){
    real_third_inner_card_ip=$(get_real_full_ip "${third_inner_card_ip}")
    if [[ $(echo "${env_ips}" | grep -iwF "${real_third_inner_card_ip}") == "" ]]
    then
        arbitration_log INFO "Not public node, index=0"
        INDEX=0
        return 0
    fi
    # 全新安装场景，INDEX=0
    if [ -f /opt/arbitration_file/new ];then
        INDEX=0
        return 0
    fi
    INDEX=$(check_installed)
    result=$?
    if [ ${result} -eq 1 ];then
        # 校验失败，退出
        echo "${INDEX}"
        return 1
    elif [ ${result} -eq 2 ];then
        INDEX=$(get_install_index)
        result=$?
        if [ ${result} -ne 0 ];then
            echo "${INDEX}"
            return 1
        fi
    fi
    return 0
}

# 判断配置文件的IP和传入的IP是否一致
# return 0 完全一致
# return 1 不完全一致
# return 2 完全不一致
# return 3 无效路径
function check_ip_include(){
    if [ "${CONF_IPS}" = "" ];then
        return 2
    fi
    echo "${CONF_IPS}" | grep "\*.\*.\*.\*" > /dev/null 2>&1
    if [ $? -eq 0 ];then
        # 安装失败的仲裁软件，直接使用
        arbitration_log INFO "installed failed path"
        return 3
    fi
    if [ "${CONF_IPS}" == " " ]
    then
        arbitration_log INFO "installed failed path"
        # 安装失败的仲裁软件，直接使用
        return 3
    fi
    ip_count=0
    include_ip_count=0
    for input_ip in ${AB_INNER_IPS[@]}
    do
        echo "${CONF_IPS}" | grep -wF "${input_ip}" > /dev/null 2>&1
        if [ $? -eq 0 ];then
            include_ip_count=$(expr ${include_ip_count} + 1)
            SAME_IPS=$(echo "${SAME_IPS} ${input_ip}")
        fi
        ip_count=$(expr ${ip_count} + 1)
    done
    if [ ${include_ip_count} -eq 0 ];then
        # 都不一致
        arbitration_log INFO "${CONF_IPS} totally different"
        return 2
    elif [ ${ip_count} -eq ${include_ip_count} ];then
        arbitration_log INFO "${CONF_IPS} totally same"
        # 完全一致
        return 0
    else
        arbitration_log INFO "${CONF_IPS} partially same"
        # 不完全一致
        return 1
    fi
}

# 从配置文件中获取仲裁软件使用到的IP
function get_ip_from_aam_conf(){
    conf_file=$1
    ips=

    if [ ${NEW_VERSION} -eq 0 ];then
        arr_conf_ips=$(cat ${conf_file} | grep 'initial_cluster=' | sed 's/initial_cluster=//g' | sed 's/,/ /g')
    else
        arr_conf_ips=$(cat ${conf_file} | grep 'initial-cluster:' | sed 's/initial_cluster://g' | sed 's/ //g' | sed 's/,/ /g')
    fi

    for get_ip_from_aam_conf_item in ${arr_conf_ips[@]}
    do
        temp_ip=$(echo "${get_ip_from_aam_conf_item}"| awk -F'//' '{print $2}' | awk -F':' '{print $1}')
        ips=$(echo "${ips} ${temp_ip}")
    done
    CONF_IPS="${ips}"
    return 0
}

# 写入配置文件
function write_properties(){
    path=/opt/arbitration_file/env.properties
    rm -rf ${path}
    echo "export ETCD_HOME=${ETCD_HOME}" >> ${path}
    echo "export MONITOR_HOME=${MONITOR_HOME}" >> ${path}
    echo "export COMMON_HOME=${COMMON_HOME}" >> ${path}
    echo "export ETCD_LOG=${ETCD_LOG}" >> ${path}
    echo "export MONITOR_LOG=${MONITOR_LOG}" >> ${path}
    echo "export INDEX=${INDEX}" >> ${path}
    echo "export ARBITRATION_HOME=${ARBITRATION_HOME}" >> ${path}
    echo "export ARBITRATION_INSTALL_LOG=${ARBITRATION_INSTALL_LOG}" >> ${path}
    echo "export ARBITTRATION_WATCHDOG_LOG=${ARBITTRATION_WATCHDOG_LOG}" >> ${path}
    echo "export ARBITRATION_LOG=${ARBITRATION_LOG}" >> ${path}
    echo "export ETCD_LOG_BASE=/var/log/arbitration-etcd" >> ${path}
    echo "export MONITOR_LOG_BASE=/var/log/arbitration-monitor" >> ${path}
    echo "export COMMON_LOG=${COMMON_LOG}" >> ${path}
    echo "export TEMP_ARBITRATION_PYTHON_HOME=${TEMP_ARBITRATION_PYTHON_HOME}" >> ${path}
    echo "export ARBITRATION_TEMP_PATH=${ARBITRATION_TEMP_PATH}" >> ${path}
    real_third_inner_card_ip=$(get_real_full_ip "${third_inner_card_ip}")
    if [[ $(echo "${env_ips}" | grep -iwF "${real_third_inner_card_ip}") != "" ]]
    then
        times=$(expr ${INDEX} + ${INDEX})
        echo "export ETCD_PORT=$(expr ${times} + 2391)" >> ${path}
        echo "export MONITOR_PORT=$(expr ${times} + 2390)" >> ${path}
    fi
}

# 检查可用的安装索引，并写入配置文件
function check_avaliable_index(){
    init_index || return 1
    echo "Available index is ${INDEX}"
    arbitration_log INFO "Available index is ${INDEX}"
    if [ ${INDEX} -eq 0 ];then
        ETCD_HOME=/opt/arbitration-etcd
        MONITOR_HOME=/opt/arbitration-monitor
        COMMON_HOME=/opt/arbitration-common
        ARBITRATION_HOME=/opt/arbitration
    else
        ETCD_HOME=/opt/arbitration-etcd_${INDEX}
        MONITOR_HOME=/opt/arbitration-monitor_${INDEX}
        COMMON_HOME=/opt/arbitration-common_${INDEX}
        ARBITRATION_HOME=/opt/arbitration_${INDEX}
    fi
    ARBITRATION_INSTALL_LOG=/var/log/arbitration_install/${INDEX}
    ARBITTRATION_WATCHDOG_LOG=/var/log/arbitration_watchdog/${INDEX}
    ARBITRATION_LOG=/var/log/arbitration/${INDEX}
    COMMON_LOG=/var/log/arbitration-common/${INDEX}
    MONITOR_LOG=/var/log/arbitration-monitor/${INDEX}
    ETCD_LOG=/var/log/arbitration-etcd/${INDEX}

    write_properties
}


function main()
{
    init $@
    check_inner_card_ip || return 1
    check_location_name || return 1
    check_arbitration_connect || return 1
    check_master_slave_already_install || return 1
    check_avaliable_index || return 1
}

main $@
exit $?