#!/bin/bash

ETCD_NAME="arbitration-etcd"

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}
getWorkPath

function getExecParam()
{
    for i in {1..3}
    do
        [[ ${1#-} == "ip" ]] && {
            SEARCH_IP=$2
            shift 2
            continue
        }
        [[ ${1#-} == "port" ]] && {
            SEARCH_PORT=$2
            shift 2
            continue
        }
        [[ ${1#-} == "index" ]] && {
            SEARCH_INDEX=$2
            shift 2
            continue
        }
    done
}


# 如果有输入IP，检查IP是否满足
function find_ip_match()
{
    local ips="$1"
    for find_ip_match_ip in ${SEARCH_IP[@]}
    do
        echo "${ips}" | grep -wF "${find_ip_match_ip}" > /dev/null 2>&1
        if [ $? -ne 0 ];then
            return 1
        fi
    done
    return 0
}

function find_index_match()
{
    local index="$1"
    for find_index_match_index in ${SEARCH_INDEX[@]}
    do
        echo "${index}" | grep -wF "${find_index_match_index}" > /dev/null 2>&1
        if [ $? -ne 0 ];then
            return 1
        fi
    done
    return 0
}

function find_port_match()
{
    local etcd_port=$1
    local server_port=$2
    local result1=
    local result2=
    for find_port_match_port in ${SEARCH_PORT[@]}
    do
        echo "${etcd_port}" | grep -wF "${find_port_match_port}" > /dev/null 2>&1
        result1=$?
        echo "${server_port}" | grep -wF "${find_port_match_port}" > /dev/null 2>&1
        result2=$?
        if [ ${result1} -ne 0 -a ${result2} -ne 0 ];then
            return 1
        fi
    done
    return 0
}

# 查询当前节点已经安装的仲裁软件的信息
function query_etcd_ips()
{
    ls /opt | grep "${ETCD_NAME}" > /dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "No arbiration software found."
        return 1
    fi
    print_title
    for item in $(ls /opt)
    do
        echo "${item}" | grep ${ETCD_NAME} > /dev/null 2>&1
        if [ $? -eq 0 ];then
            aam_properties=/opt/"${item}"/conf/etcd_server.yaml
            if [ ! -f "${aam_properties}" ];then
                aam_properties=/opt/"${item}"/conf/etcd_server.properties
            fi
            if [ ! -f "${aam_properties}" ];then
                continue
            fi
            ips=$(get_ip_from_aam_conf "${aam_properties}")
            etcd_port=$(get_etcd_port_from_aam_conf "${aam_properties}")
            server_port=$(get_server_port_from_aam_conf "${aam_properties}")
            echo "${item}" | grep "${ETCD_NAME}_" > /dev/null 2>&1
            if [ $? -ne 0 ];then
                index=0
            else
                index=$(echo "${item}" | sed "s/${ETCD_NAME}_//g")
            fi
            find_ip_match "${ips}" || continue
            find_port_match "${etcd_port}" "${server_port}" || continue
            find_index_match ${index} || continue
            print_info "${index}" "${ips}" "${etcd_port}" "${server_port}"
        fi
    done
}


function print_title()
{
    printf "%-10s%-60s%-20s%-10s\n" "INDEX" "IP" "ETCD_PORT" "SERVER_PORT"
}

function print_info()
{
    local index=$1
    local ip=$2
    local etcd_port=$3
    local server_port=$4
    printf "%-10s%-60s%-20s%-10s\n" "${index}" "${ip}" " ${etcd_port}" "${server_port}"
}


# 从配置文件中获取仲裁软件使用到的IP
function get_ip_from_aam_conf()
{
    conf_file=$1
    ips=

    echo "${conf_file}" | grep 'yaml$' > /dev/null 2>&1
    if [ $? -ne 0 ];then
        arr_conf_ips=$(cat ${conf_file} | grep 'initial_cluster=' | sed 's/initial_cluster=//g' | sed 's/,/ /g')
    else
        arr_conf_ips=$(cat ${conf_file} | grep 'initial-cluster:' | sed 's/initial_cluster://g' | sed 's/ //g' | sed 's/,/ /g')
    fi
    local port=
    for get_ip_from_aam_conf_item in ${arr_conf_ips[@]}
    do
        port=$(echo "${get_ip_from_aam_conf_item}"| awk -F":" '{print $NF}')
        temp_ip=$(echo "${get_ip_from_aam_conf_item}"| awk -F'//' '{print $2}' | awk -F":${port}" '{print $1}')
        ips=$(echo "${ips} ${temp_ip}")
    done
    echo "${ips}" | sed 's/^ //g'
    return 0
}

# 从配置文件中获取仲裁软件使用到的ETCD端口
function get_etcd_port_from_aam_conf()
{
    conf_file=$1
    local port=

    echo "${conf_file}" | grep 'yaml$' > /dev/null 2>&1
    if [ $? -ne 0 ];then
        port=$(cat ${conf_file} | grep 'initial_advertise_peer_urls=' | awk -F':' '{print $NF}')
    else
        port=$(cat ${conf_file} | grep 'listen-peer-urls:' | awk -F':' '{print $NF}')
    fi

    echo "${port}"
    return 0
}

# 从配置文件中获取仲裁软件使用到的服务端端口
function get_server_port_from_aam_conf()
{
    conf_file=$1
    local port=

    echo "${conf_file}" | grep 'yaml$' > /dev/null 2>&1
    if [ $? -ne 0 ];then
        port=$(cat ${conf_file} | grep 'listen_client_urls=' | awk -F':' '{print $NF}')
    else
        port=$(cat ${conf_file} | grep 'listen-client-urls:' | awk -F':' '{print $NF}')
    fi

    echo "${port}"
    return 0
}

function main()
{
    getExecParam $@
    query_etcd_ips || return 1
}

main $@