#! /bin/bash

. ./arbitration_opertate_lib

function recover_ssh()
{
    third_node_sek_select=$1
    local fun_name="RECOVER_SSH_CONFIG"
    arbitration_log INFO "${fun_name}" "This node is third node."

    cd /opt/NCEICMR
    if [[ "${third_node_sek_select}" == "third_node_sek_select_yes" ]]
    then
        echo "sh install.sh -silent en_US OMP" >> ${ARBITRATION_INSTALL_LOG_FILE_PATH}
        sh install.sh -silent en_US OMP 2>${ARBITRATION_INSTALL_LOG_FILE_PATH} | tee -a ${ARBITRATION_INSTALL_LOG_FILE_PATH}
    else
        echo "sh install.sh -silent en_US OMP NotSek" >> ${ARBITRATION_INSTALL_LOG_FILE_PATH}
        sh install.sh -silent en_US OMP NotSek 2>${ARBITRATION_INSTALL_LOG_FILE_PATH} | tee -a ${ARBITRATION_INSTALL_LOG_FILE_PATH}
    fi
    if [ $? -ne 0 ];then
        echo "Install ICMR failed" >&2
        arbitration_log ERROR "${fun_name}" "Install ICMR failed"
    fi

    arbitration_log INFO "${fun_name}" "Install ICMR success"

    bash /opt/SEK/cmd/SetEnv.sh >/dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "Set Env failed" >&2
    fi

    arbitration_log INFO "${fun_name}" "Third node needs reinforce."
}

function main()
{
    recover_ssh $@
}

main $@