#!/bin/bash



omp_ip_address=$1
login_user_name=$2
operation_type=$3
target_field=$4
read -s -p "please input login password:" login_user_pwd
read -s -p "please input ossadm password:" ossadm_user_pwd
read -s -p "please input the value:" random_pwd

# 转义特殊字符
login_user_pwd=$(echo ${login_user_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
ossadm_user_pwd=$(echo ${ossadm_user_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
random_pwd=$(echo ${random_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')

# 登录OMP节点，执行OMP上预置的刷新ha.properties的脚本modify_ha.sh 
function remote_exec()
{
    ${EXPECT} << ENF >/dev/null 2>&1
set timeout 30
spawn /usr/bin/ssh ${login_user_name}@${omp_ip_address} 
expect {
    "*yes/no*" {send "yes\r";exp_continue}
    "*assword:" {send "${login_user_pwd}\r"}
}

expect {
    "*${login_user_name}@*" {
                            send "su - ossadm\r"
                            expect {
                                "*yes/no*" {send "yes\r";exp_continue}
                                "*assword:" {send "${ossadm_user_pwd}\r"}
                                "*ossadm@*" {send "\r"}
                            }
    
                            expect {
                                "*ossadm@*" {
                                            send "bash /opt/oss/manager/apps/DRService/shscript/modify_ha.sh ${operation_type} ${target_field}\r"
                                            expect {
                                                    "please input the value:" {send "${random_pwd}\r"}
                                                   }
                                            expect {
                                                "*modify properties failed*" { exit 255 }
                                                "*modify properties successfully*" { exit 100 }
                                                }
                                            }
                            }
                            
                            expect {
                                "*ossadm@*" {send "exit\r"}
                            }
    
    }
}

expect {
    "*${login_user_name}@*" {send "exit\r"}
}

expect eof

catch wait result
exit [lindex $result 3]

ENF

return $?
}
cd /opt/arbitration_file
. ./env.properties
. ./arbitration_opertate_lib
EXPECT=/usr/bin/expect

arbitration_log INFO "REMOTE_MODIFY_HA" "start to modify properties and retry, the omp ip is ${omp_ip_address}"

function get_omp_maintaince_ip()
{
    arbitration_log INFO "REMOTE_MODIFY_HA" "Start to get the OMP maintenance IP address."
    omp_maintaince_ip=$(su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh;ipmc_adm -cmd statusapp -app DRService -tenant manager -nodeip global |grep -w 'DRService' | sed -n '1p'| awk '{print \$6}'")
    arbitration_log INFO "REMOTE_MODIFY_HA" "Success to get the OMP maintenance IP address is ${omp_maintaince_ip}."
    echo ${omp_maintaince_ip}
}

omp_ip_address=$(get_omp_maintaince_ip)
if [ -z "${omp_ip_address}" ]
then
    arbitration_log ERROR "REMOTE_MODIFY_HA" "Failed to get the OMP maintenance IP address."
    echo "modify properties failed"
    exit 255
fi

arbitration_log INFO "REMOTE_MODIFY_HA" "Get the OMP maintenance IP address: ${omp_ip_address}"
for i in {1..3}
do
    remote_exec
    remote_exec_result=$?
    if [ ${remote_exec_result} -eq 100 ]
    then
        break
    fi
    arbitration_log INFO "REMOTE_MODIFY_HA" "retry to modify remote ha properties"
    sleep 1
done

if [ ${remote_exec_result} -ne 100 ]
then
    echo "modify properties failed"
    arbitration_log ERROR "REMOTE_MODIFY_HA" "modify properties failed."
else
    echo "modify properties successfully"
    arbitration_log INFO "REMOTE_MODIFY_HA" "modify properties successfully."
fi

