#!/bin/bash

. ./arbitration_opertate_lib
. ./env.properties
. ./public.sh

function create_check_file()
{
    result_code=$1
    echo "#!/bin/bash
echo  RESULT:${result_code} && rm -rf /opt/arbitration_file/check_sync_keystore_result.sh
   ">/opt/arbitration_file/check_sync_keystore_result.sh

   chmod 500 /opt/arbitration_file/check_sync_keystore_result.sh
}
. ./public.sh
rm -rf /opt/arbitration_file/check_sync_keystore_result.sh

if [ $(is_generate_cert) == "false" ]
then
    $(create_check_file 100)
    exit 0
fi

site_role=$1
omp_ip_address=$2
local_ip_address=$3

echo "es_input: master_omp_node_uname"
read master_login_user_name
echo "es_input: master_omp_node_pwd"
read -s master_login_user_pwd
echo "es_input: master_omp_node_ossadm_pwd"
read -s master_ossadm_user_pwd
echo "es_input: node_1_root_pwd"
read -s master_commonservice_root_pwd

echo "es_input: slave_omp_node_uname"
read slave_login_user_name
echo "es_input: slave_omp_node_pwd"
read -s slave_login_user_pwd
echo "es_input: slave_omp_node_ossadm_pwd"
read -s slave_ossadm_user_pwd
echo "es_input: node_3_root_pwd"
read -s slave_commonservice_root_pwd

if [ "${site_role}" = "-master" ]
then
    login_user_name=${master_login_user_name}
    login_user_pwd=${master_login_user_pwd}
    ossadm_user_pwd=${master_ossadm_user_pwd}
    commonservice_root_pwd=${master_commonservice_root_pwd}
else
    login_user_name=${slave_login_user_name}
    login_user_pwd=${slave_login_user_pwd}
    ossadm_user_pwd=${slave_ossadm_user_pwd}
    commonservice_root_pwd=${slave_commonservice_root_pwd}
fi

login_user_pwd=$(echo ${login_user_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
ossadm_user_pwd=$(echo ${ossadm_user_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
commonservice_root_pwd=$(echo ${commonservice_root_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')

function get_omp_maintaince_ip()
{
    arbitration_log INFO "SYNC_KEYSTORE" "Start to get the OMP maintenance IP address."
    omp_maintaince_ip=$(su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh;ipmc_adm -cmd statusapp -app DRService -tenant manager -nodeip global |grep -w 'DRService' | sed -n '1p'| awk '{print \$6}'")
    arbitration_log INFO "SYNC_KEYSTORE" "Success to get the OMP maintenance IP address is ${omp_maintaince_ip}."
    echo ${omp_maintaince_ip}
}

# 登录OMP节点，执行OMP上预置的sync_keystore.sh脚本
function remote_exec()
{
    ${EXPECT} << ENF >/dev/null 2>&1
spawn /usr/bin/ssh ${login_user_name}@${omp_ip_address} 
expect {
    "*yes/no*" {send "yes\r";exp_continue}
    "*assword:" {send "${login_user_pwd}\r"}
}

expect {
    "*${login_user_name}@*" {
                            send "su - ossadm\r"
                            expect {
                                "*yes/no*" {send "yes\r";exp_continue}
                                "*assword:" {send "${ossadm_user_pwd}\r"}
                                "*ossadm@*" {send "\r"}
                            }
    
                            expect {
                                "*ossadm@*" {
                                    send "bash /opt/oss/manager/apps/DRService/shscript/sync_keystore.sh ${local_ip_address} /opt/arbitration_tmp ${sha256_clientKeyStore} ${sha256_clientTrustStore}\r"
                                    expect {
                                        "please input root password:" {send "${commonservice_root_pwd}\r"}
                                    }
                                    
                                    expect {
                                        "*synchronize keystore failed*" { exit 255 }
                                        "*synchronize keystore successfully*" { exit 100 }
                                    }
                                }
                            }
                            
                            expect {
                                "*ossadm@*" {send "exit\r"}
                            }
    
    }
}

expect {
    "*${login_user_name}@*" {send "exit\r"}
}

expect eof

catch wait result
exit [lindex $result 3]

ENF
    sync_result=$?
    
    if [ ${sync_result} -ne 100 ]
    then
        arbitration_log ERROR "SYNC_KEYSTORE" "Synchronize keystore failed."
        [ -d "/opt/arbitration_tmp" ] && rm -rf /opt/arbitration_tmp
        return 255
    else
        arbitration_log INFO "SYNC_KEYSTORE" "Synchronize keystore successfully."
        return 0
    fi
}

function copy_keystore()
{   
    rm -rf /opt/arbitration_file/check_sync_keystore_result.sh
    
    [ -d "/opt/arbitration_tmp" ] && rm -rf /opt/arbitration_tmp
    mkdir -p /opt/arbitration_tmp

    # 获取文件的sha256校验码，scp后需要校验
    sha256_clientKeyStore=$(/usr/bin/sha256sum ${src_keystore_path}/clientKeyStore.keystore | awk '{print $1}')
    sha256_clientTrustStore=$(/usr/bin/sha256sum ${src_keystore_path}/clientTrustStore.keystore | awk '{print $1}')

    # 拷贝keystore
    cp -f ${src_keystore_path}/clientKeyStore.keystore /opt/arbitration_tmp
    cp -f ${src_keystore_path}/clientTrustStore.keystore /opt/arbitration_tmp
    
    # 控制属组和权限
    chown -R ossadm:ossgroup /opt/arbitration_tmp
    chmod 600 /opt/arbitration_tmp/*
}

EXPECT=/usr/bin/expect

# 根据用户输入的omp节点IP获取maintaince IP
omp_ip_address=$(get_omp_maintaince_ip)
src_keystore_path="${MONITOR_HOME}/keystore"
dst_keystore_path="/opt/oss/share/manager/DRService/ssl/etcd_ssl/client/"

# 复制keystore并刷成ossadm属组，方便OMP节点拷贝
copy_keystore

# 执行脚本将keystore拷贝到OMP

for i in {1..3}
do
    remote_exec
    remote_exec_result=$?
    if [ ${remote_exec_result} -eq 0 ]
    then
        break
    fi
    arbitration_log INFO "SYNC_KEYSTORE" "retry to remote sync keystore"
    sleep 1
done

[ -d "/opt/arbitration_tmp" ] && rm -rf /opt/arbitration_tmp

if [ ${remote_exec_result} -ne 0 ]
then
    $(create_check_file 255)
    exit 255
fi
$(create_check_file 100)
