#!/bin/bash
. ./arbitration_opertate_lib

##替换etcd证书
function replace_etcd_certification()
{
    arbitration_log INFO "REPLACE_CERTIFICATION" "Replace the etcd certifications."
    cp -p /opt/backup_arbitration/opt_arbitration/arbitration-etcd/keystore/serverKeyStore.keystore  /opt/arbitration-etcd/keystore/
    cp -p /opt/backup_arbitration/opt_arbitration/arbitration-etcd/keystore/serverTrustStore.keystore  /opt/arbitration-etcd/keystore/
     
    ssl_keyStore_password1=`cat /opt/backup_arbitration/opt_arbitration/arbitration-etcd/conf/etcd_server.properties |grep ssl_keyStore_password`
    ssl_keyStore_password=${ssl_keyStore_password1#*=}
    ssl_trustStore_password1=`cat /opt/backup_arbitration/opt_arbitration/arbitration-etcd/conf/etcd_server.properties |grep ssl_trustStore_password`
    ssl_trustStore_password=${ssl_trustStore_password1#*=}

    sed -i "s?ssl_keyStore_password=.*?ssl_keyStore_password=${ssl_keyStore_password}?" /opt/arbitration-etcd/conf/etcd_server.properties
    sed -i "s?ssl_trustStore_password=.*?ssl_trustStore_password=${ssl_trustStore_password}?" /opt/arbitration-etcd/conf/etcd_server.properties
    arbitration_log INFO "REPLACE_CERTIFICATION" "Replace the etcd certifications successfully."
}

##替换monitor证书
function replace_monitor_certification()
{
    arbitration_log INFO "REPLACE_CERTIFICATION" "Replace the monitor certifications."
    cp -p /opt/backup_arbitration/opt_arbitration/arbitration-monitor/keystore/clientKeyStore.keystore  /opt/arbitration-monitor/keystore/
    cp -p /opt/backup_arbitration/opt_arbitration/arbitration-monitor/keystore/clientTrustStore.keystore  /opt/arbitration-monitor/keystore/
     
    KeyStore1=`cat /opt/backup_arbitration/opt_arbitration/arbitration-monitor/conf/aam.properties |grep aam.local.etcdKeystorePhase`
    KeyStore=${KeyStore1#*=}
    trustStore1=`cat /opt/backup_arbitration/opt_arbitration/arbitration-monitor/conf/aam.properties |grep aam.local.etcdTruststorePhase`
    trustStore=${trustStore1#*=}
    
    sed -i "s?aam.local.etcdKeystorePhase=.*?aam.local.etcdKeystorePhase=${KeyStore}?" /opt/arbitration-monitor/conf/aam.properties
    sed -i "s?aam.local.etcdTruststorePhase=.*?aam.local.etcdTruststorePhase=${trustStore}?" /opt/arbitration-monitor/conf/aam.properties
    arbitration_log INFO "REPLACE_CERTIFICATION" "Replace the monitor certifications successfully."
}


function main()
{
    arbitration_log INFO "REPLACE_CERTIFICATION" "Start replace the certifications."
    replace_etcd_certification
    replace_monitor_certification
    arbitration_log INFO "REPLACE_CERTIFICATION" "Replace the certifications successfully."
}

main

