#!/bin/bash
#coding=utf-8

function getWorkPath()
{
    dir=$(dirname "$0")
    ispointstart=$(echo "${dir}"|awk -F/ '{print $1}')
    if [ "${ispointstart}" == "." ]
    then
        dir=$(echo "${dir}"|sed 's/^.//')
        curPath="$(pwd)${dir}"
    elif [ "${ispointstart}" == ".." ]
    then
        curPath="$(pwd)/${dir}"
    else
        curPath="${dir}"
    fi
    return 0
}

function init()
{
    ARBITRATION_PATH="/opt/arbitration"
    if [ ! -d ${ARBITRATION_PATH} ]
    then
        echo "[`date "+%Y-%m-%d %H:%M:%S"`] No script needs to be run for non-arbitration nodes."
        return 1
    fi
    . ${ARBITRATION_PATH}/env/env.properties
}

function check_arbitration()
{
    bash "${curPath}"/user_util.sh || return 1

    rm -rf  /opt/arbitration-etcd/member/*
    # 重启服务
    su - arbiter -s /bin/sh -c "/bin/sh ${MONITOR_HOME}/script/service.sh restart >/dev/null 2>&1"
    su - arbiter -s /bin/sh -c "/bin/sh ${ETCD_HOME}/script/service.sh restart >/dev/null 2>&1"

    grep aamonitor_watchdog.sh /etc/crontab | grep -v "^#">/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        aamonitor_watchdog_path_format=$(echo "${ARBITRATION_HOME}/script/aamonitor_watchdog.sh" | sed 's/\//\\\//g')
        if [[ -e /etc/SuSE-release ]]
        then
            sed -i "/${aamonitor_watchdog_path_format}/d" /etc/crontab
            echo "*/1 * * * * root /bin/sh ${ARBITRATION_HOME}/script/aamonitor_watchdog.sh >/dev/null 2>&1" >> /etc/crontab
            service cron restart > /dev/null
        elif [[ -e /etc/euleros-release ]]
        then
            sed -i "/${aamonitor_watchdog_path_format}/d" /etc/crontab
            echo "*/1 * * * * root /bin/sh ${ARBITRATION_HOME}/script/aamonitor_watchdog.sh >/dev/null 2>&1" >> /etc/crontab
            systemctl restart crond.service > /dev/null
        else
            if [[ -e /var/spool/cron/root ]]
            then
                sed -i "/${aamonitor_watchdog_path_format}/d" /var/spool/cron/root
                echo "*/1 * * * * /bin/sh ${ARBITRATION_HOME}/script/aamonitor_watchdog.sh  >/dev/null 2>&1" >>  /var/spool/cron/root
            else
                arbitration_log INFO "CONFIG_AAMONITOR_WATCHDOT" "Create root watchdog."
                echo "*/1 * * * * /bin/sh ${ARBITRATION_HOME}/script/aamonitor_watchdog.sh  >/dev/null 2>&1" >  /var/spool/cron/root
                chmod 600 /var/spool/cron/root
            fi
        fi
        if [ $? -ne  0 ]
        then
            echo "[`date "+%Y-%m-%d %H:%M:%S"`] Failed to configure the aamonitor_watchdog task."
            return 1
        fi
    fi
}

function main()
{
    echo "[`date "+%Y-%m-%d %H:%M:%S"`] Start to run restore_arbitration.sh. "
    getWorkPath
    init || return 1
    check_arbitration
    if  [ $? -ne 0 ]
    then
        echo "[`date "+%Y-%m-%d %H:%M:%S"`] Failed to run restore_arbitration.sh."
    else
        echo "[`date "+%Y-%m-%d %H:%M:%S"`] The restore_arbitration.sh script is successfully run."
    fi
}

main
