#! /bin/bash
. ./arbitration_opertate_lib
. ./env.properties
ARBITRATION_WATCHDOG_LOG_FILE_PATH="${ARBITTRATION_WATCHDOG_LOG}/arbitration_watchdog.log"
ARBITRATION_CONFIG_PATH="${ARBITRATION_HOME}/conf/arbitration_conf.properties"

master_nodes_inner_ips=$1
slave_nodes_inner_ips=$2
third_node_inner_ip=$3
master_location_name=$4
slave_location_name=$5
ntp_server_ip=$6

########################################################
#
#
#       准备目录
#
#
########################################################
function init()
{
    mkdir -p ${ARBITTRATION_WATCHDOG_LOG}
    chmod -Rf 500 ${ARBITTRATION_WATCHDOG_LOG}
    mkdir -p ${ARBITRATION_HOME}/script
    mkdir -p ${ARBITRATION_HOME}/conf
    mkdir -p ${ARBITRATION_HOME}/env
    chmod -Rf 500 ${ARBITRATION_HOME}
    cp /opt/arbitration_file/env.properties ${ARBITRATION_HOME}/env
}

########################################################
#
#
#       记录仲裁配置
#
#
########################################################
function record_arbitration_conf()
{
    arbitration_log INFO "RECORD_ARBITRATION_CONFIG" "Start record arbitration configuration."
    echo "master_nodes_inner_ips=${master_nodes_inner_ips}" > ${ARBITRATION_CONFIG_PATH}
    echo "slave_nodes_inner_ips=${slave_nodes_inner_ips}" >> ${ARBITRATION_CONFIG_PATH}
    echo "third_node_inner_ip=${third_node_inner_ip}" >> ${ARBITRATION_CONFIG_PATH}
    echo "ntp_server_ip=${ntp_server_ip}" >> ${ARBITRATION_CONFIG_PATH}
    echo "master_location_name=${master_location_name}" >> ${ARBITRATION_CONFIG_PATH}
    echo "slave_location_name=${slave_location_name}" >> ${ARBITRATION_CONFIG_PATH}
    chmod -f 500 ${ARBITRATION_CONFIG_PATH}
}

########################################################
#
#
#       修改文件出现
#
#
########################################################
function modify_dir_chmod_chown()
{
    arbitration_log INFO "MODIFY_DIR_CHMOD_CHOWN" "Start modify."
    chown -Rf arbiter:ArbiterGroup ${ETCD_HOME}
    chown -Rf arbiter:ArbiterGroup ${MONITOR_HOME}
    chown -Rf arbiter:ArbiterGroup ${COMMON_HOME}
    find ${COMMON_HOME} -name "*.sh" | xargs -r chmod 500
}

########################################################
#
#
#       仲裁软件守护进程
#
#
########################################################
function start_arbitration_watchdog()
{
    arbitration_log INFO "START_AAMONITOR_WATCHDOT" "Start watchdog."
    cp /opt/arbitration_file/aamonitor_watchdog.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/query_arbitration.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/uninstall_arbitration.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/public.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/common_ntp.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/ntpd_util.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/chronyd_util.sh ${ARBITRATION_HOME}/script
    cp /opt/arbitration_file/ntpType ${ARBITRATION_HOME}/script
    chmod -Rf 500 ${ARBITRATION_HOME}/script
    aamonitor_watchdog_path_format=$(echo "${ARBITRATION_HOME}/script/aamonitor_watchdog.sh" | sed 's/\//\\\//g')
    if [[ -e /etc/SuSE-release ]]
    then
        sed -i "/${aamonitor_watchdog_path_format}/d" /etc/crontab
        echo "*/1 * * * * root /bin/sh ${ARBITRATION_HOME}/script/aamonitor_watchdog.sh >/dev/null 2>&1" >> /etc/crontab
        service cron restart > /dev/null
    elif [[ -e /etc/euleros-release ]]
    then
        sed -i "/${aamonitor_watchdog_path_format}/d" /etc/crontab
        echo "*/1 * * * * root /bin/sh ${ARBITRATION_HOME}/script/aamonitor_watchdog.sh >/dev/null 2>&1" >> /etc/crontab
        systemctl restart crond.service > /dev/null
    else
        if [[ -e /var/spool/cron/root ]]
        then
            sed -i "/${aamonitor_watchdog_path_format}/d" /var/spool/cron/root
            echo "*/1 * * * * /bin/sh ${ARBITRATION_HOME}/script/aamonitor_watchdog.sh  >/dev/null 2>&1" >>  /var/spool/cron/root
        else
            arbitration_log INFO "CONFIG_AAMONITOR_WATCHDOT" "Create root watchdog."
            echo "*/1 * * * * /bin/sh ${ARBITRATION_HOME}/script/aamonitor_watchdog.sh  >/dev/null 2>&1" >  /var/spool/cron/root
            chmod 600 /var/spool/cron/root
        fi
    fi 
}
###########################################################################################
#
#
#       老版本由于使用cron，导致/var/spool/clientmqueue爆满而升级仲裁节点操作系统失败
#       避免在/var/spool/clientmqueue下生成文件，修改相关配置文件
#       只有三方站点需要此操作
#
#
###########################################################################################
function fn_stop_crond_mail()
{
    arbitration_log INFO "UPGRADE_POST_OPERATION" "the node id third: ${is_third}"
    local aam_properties="${MONITOR_HOME}/conf/aam.properties"
    local is_third=$(cat ${aam_properties} | grep "aam.local.role" | awk -F'=' '{print $2}')
    arbitration_log INFO "UPGRADE_POST_OPERATION" "the node id third: ${is_third}"
    [ "${is_third}" != "third" ] && return 0

    [ -e /etc/euleros-release ] && [ "$(grep -i euler /etc/euleros-release)" ]  || return 0
    if [ ! -f /etc/crontab -o ! -f /etc/sysconfig/crond ]
    then
        arbitration_log ERROR "UPGRADE_POST_OPERATION" "File /etc/crontab or /etc/sysconfig/crond is not found."
        return 0
    fi
    grep -q "^\s*MAILTO=['\"]*root['\"]*\s*$" /etc/crontab || { arbitration_log ERROR "UPGRADE_POST_OPERATION" "The MAILTO value does not meet the requirements."; return 0; }
    grep -q "^\s*CRONDARGS=.*-m off" /etc/sysconfig/crond && { arbitration_log INFO "UPGRADE_POST_OPERATION" "is already set. "; return 0; }
    local args_centont=$(egrep "^\s*CRONDARGS=" /etc/sysconfig/crond | sed -e 's/^\s*CRONDARGS=//' -re 's/^\s*"|"\s*$//g' -e "s/^\s*'|'\s*$//g")

    if [ -z "${args_centont}" ]
    then
        sed -ri '/^\s*CRONDARGS=/c\CRONDARGS="-m off"' /etc/sysconfig/crond
    else
        sed -ri "/^\s*CRONDARGS=/c\CRONDARGS=\"-m off ${args_centont}\"" /etc/sysconfig/crond
    fi

    sed -ri '/^\s*MAILTO=root/c\MAILTO=""' /etc/crontab
    [ -f /etc/crontab ] && sed -i '/check_IO_status.sh/d' /etc/crontab
    systemctl restart crond
    return 0
}

function upgrade_post_operation() {
    local upgrade_flag=/opt/backupArb/arbitration_upgrade.flag
    [ ! -f ${upgrade_flag} ] && return 0
    # 升级场景，删除运行升级flag文件
    local upgrade_running_flag=/opt/backupArb/arbitration_upgrade_running.flag
    if [ -f ${upgrade_running_flag} ]
    then
        arbitration_log INFO "UPGRADE_POST_OPERATION" "delete upgrade running flag"
        rm -rf ${upgrade_running_flag}
    fi

    arbitration_log INFO "UPGRADE_POST_OPERATION" "upgrade post operation"
    # 设置crond相关配置，避免inode达到100%
    fn_stop_crond_mail
    rm -rf ${upgrade_flag}
    arbitration_log INFO "UPGRADE_POST_OPERATION" "upgrade post operation success"
}

function post_operation()
{
    arbitration_log INFO "POST_OPERATION" "start to post operation"
    if [ -d ${ARBITRATION_TEMP_PATH} ]
    then
        rm -rf ${ARBITRATION_TEMP_PATH}
    fi
    arbitration_log INFO "POST_OPERATION" "success to post operation"
}

function main()
{
    init
    record_arbitration_conf
    modify_dir_chmod_chown
    start_arbitration_watchdog
    upgrade_post_operation
    post_operation
}

main