#!/bin/bash

ETCD_PORT=
MONITOR_PORT=
LOG_PATH=
function init_log(){
    LOG_PATH=/tmp/arbitration_update_port.log
    echo "$(date) Begin to update port" > "${LOG_PATH}"
}
function copy_file(){
   local third_ip=$1
   local pwd=$2
(
   /usr/bin/expect <<EOF
       set timeout 30
       spawn scp ${third_ip}:/opt/arbitration_file/env.properties /opt/arbitration_file/env_third.properties
   expect {
   "*yes/no*" {
       send "yes\r"
       exp_continue
   }
   "*assword:" {
       send "${pwd}\r"
   }
   "*not known*" {
       puts "Unresolved hostname!"
       exit 1
   }
   }
   expect timeout {
        exit 1
    }
EOF
) > /dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "failed to copy third env" >&2
        return 1
    fi
}

function get_port(){
   ETCD_PORT=$(cat /opt/arbitration_file/env_third.properties | grep "ETCD_PORT=" | awk -F"=" '{print $2}')
   MONITOR_PORT=$(cat /opt/arbitration_file/env_third.properties | grep "MONITOR_PORT=" | awk -F"=" '{print $2}')
}

function set_port(){
    sed -i '/ETCD_PORT=/d' /opt/arbitration_file/env.properties > /dev/null 2>&1 || return 1
    sed -i '/MONITOR_PORT=/d' /opt/arbitration_file/env.properties > /dev/null 2>&1 || return 1
    echo "export ETCD_PORT=${ETCD_PORT}" >>/opt/arbitration_file/env.properties || return 1
    echo "export MONITOR_PORT=${MONITOR_PORT}" >>/opt/arbitration_file/env.properties || return 1
    rm -f /opt/arbitration_file/env_third.properties
}
function main(){
    local inner_ip=$1
    init_log
    refresh_port ${inner_ip} || return 1
}

function refresh_port()
{
    local input_ip5="$1"
    echo "es_input: node_5_root_pwd"
    read node5_root_pwd
    node5_root_pwd=$(echo ${node5_root_pwd} | sed 's/\\/\\\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\\\\"/g')
    [ -f /root/.ssh/known_hosts ] && sed -i "/^${input_ip5} /d" /root/.ssh/known_hosts
    echo ${input_ip5} | grep ":" >> "${LOG_PATH}"
    if [ $? -ne 0 ];then
      copy_file ${input_ip5} ${node5_root_pwd} || return 1
    else
      # IPV6
      copy_file "\["${input_ip5}"\]" ${node5_root_pwd} || return 1
    fi
    # 获取端口
    if [ -f /opt/arbitration_file/env_third.properties ]
    then
        get_port
    else
        echo "No env_third.properties file found" >> "${LOG_PATH}"
        echo "No env_third.properties file found" >&2
        return 1
    fi
    set_port
    echo "refresh port success" >> "${LOG_PATH}"
}


#记录结果
function create_check_file()
{
    result_code=$1
    echo "#!/bin/bash
echo  RESULT:${result_code}
    ">/opt/arbitration_file/check_update_port_result.sh

    chmod 500 /opt/arbitration_file/check_update_port_result.sh
}

function do_exit()
{
    return_code=$1
    if [ ${return_code} -eq 0 ];then
        create_check_file 100
    else
        create_check_file 255
    fi

    exit ${return_code}
}

main $@
do_exit $?
