#!/bin/bash
set +x

. /etc/profile
. /opt/arbitration_file/env.properties

function add_account()
{
    cat /etc/group | grep ArbiterGroup  > /dev/null 2>&1
    if [ $? -ne 0 ]
    then
        groupadd -g 3501 ArbiterGroup
        if [ $? -ne 0 ]
        then
            echo "create the ArbiterGroup group failed."
            return 1
        fi
    fi
    local IS_NEW_USER=0
    id arbiter > /dev/null 2>&1
    if [ $? -ne 0 ]
    then
        IS_NEW_USER=1
        useradd arbiter -m -d /home/ArbiterGroup -u 3501 -g ArbiterGroup -s /sbin/nologin >/dev/null 2>&1
        if [ $? -ne 0 ]
        then
            echo "create the arbiter user failed."
            return 1
        fi
    else
        cat /etc/passwd | grep '^arbiter' | grep '/sbin/nologin' > /dev/null 2>&1
        if [ $? -ne 0 ]
        then
            sed -i 's/^arbiter:.*/arbiter:x:3501:3501::\/home\/ArbiterGroup:\/sbin\/nologin/' /etc/passwd
        fi
    fi

    if [ ! -f ${COMMON_HOME}/conf/arbiterPasswd.conf ]
    then
        echo "the passwd conf not exist."
        return 1
    fi

    # set arbiter password to empty
    if [ ${IS_NEW_USER} -eq 0 ];then
        local tmp_passwd=$(cat "${COMMON_HOME}/conf/arbiterPasswd.conf")

        sed -i -e '/^arbiter/d' /etc/shadow
        echo "${tmp_passwd}" >> /etc/shadow
    fi
    chage -M 99999 arbiter
    return 0
}

function main() {
    add_account
    exit $?
}

main