#!/bin/bash
set +x

. /etc/profile
. /opt/arbitration_file/env.properties
TMOUT=0

rootDir=$(echo $(cd "$(dirname "$0")"; pwd))

function add_account()
{
    echo "begin to add the arbiter account ..."
    bash /opt/arbitration_file/user_util.sh
    return $?
}

function cron_hwclock()
{
    echo "begin to config hwclock cron task ..."


    sed -i -e '/hwclock/d' /etc/crontab
    # The value must be the same as that configured in the ICMR.
    echo "*/1 * * * * root hwclock --systohc > /dev/null 2>&1" >> /etc/crontab
    if [ $? -ne 0 ]
    then
        echo "config hwclock cron task failed."
        return 1
    fi

    return 0
}

function setup_jre()
{
    echo "begin to setup Java Runtime Environment ..."
    #jre name jre-2.2.5.zip,create dir /usr/java/jre-2.2.5
    jre_zip_name=`ls $rootDir/../foss | grep jre`
    jre_name=`echo ${jre_zip_name%.zip}`
    jre_home="${rootDir}/../foss/java/${jre_name}"
    mkdir -p ${jre_home}
    unzip -o $rootDir/../foss/jre-*.zip -d ${jre_home} > /dev/null 2>&1
    if [ $? -ne 0 ]
    then
        echo "extract jre package failed."
        return 1
    fi

    sed -i '/ARBITRATION_JAVA_HOME=/d' /opt/arbitration_file/env.properties
    jre_home_abs=`echo $(cd ${jre_home};pwd)`
    echo "export ARBITRATION_JAVA_HOME=${jre_home_abs}" >> /opt/arbitration_file/env.properties

    chmod 550 "${rootDir}/../foss/java" -R
    chown arbiter:ArbiterGroup "${rootDir}/../foss/java" -R
    return 0
}

function setup_python()
{
    echo "begin to setup python environment ..."
    # python package name python.zip

    mkdir -p "${rootDir}/../foss/python"
    unzip -o "${rootDir}"/../foss/python.zip -d "${rootDir}/../foss/python" > /dev/null 2>&1
    if [ $? -ne 0 ]
    then
        echo "extract python package failed."
        return 1
    fi

    chmod 550 $rootDir/../foss/python -R
    chown arbiter:ArbiterGroup $rootDir/../foss/python -R
    return 0
}

function main()
{
    add_account
    if [ $? -ne 0 ]
    then
        return 1
    fi

    cron_hwclock
    if [ $? -ne 0 ]
    then
        return 1
    fi

    setup_jre
    if [ $? -ne 0 ]
    then
        return 1
    fi

    setup_python
    if [ $? -ne 0 ]
    then
        echo "set python environment failed."
        return 1
    fi
    
    #for alarm agent service and log
    chown arbiter: ${COMMON_HOME}/script/
    chown arbiter: ${COMMON_HOME}
    mkdir -p ${COMMON_LOG}
    chmod 750 ${COMMON_LOG}
    chown arbiter: ${COMMON_LOG} -R
    
    echo "execute setup-all.sh success."
    return 0
}

main
exit $?
