#!/bin/bash
SOURCE="${BASH_SOURCE[0]}"
SCRIPT_FILE_PATH=`/usr/bin/readlink -e ${SOURCE}`
SCRIPT_DIR=`/usr/bin/dirname ${SCRIPT_FILE_PATH}`
APP_PATH=`/usr/bin/dirname ${SCRIPT_DIR}`
PYTHON_PATH=${APP_PATH}/rtsp/python/bin

. ${APP_PATH}/lbin/init_deploy.sh
. ${APP_PATH}/lbin/env_profile.sh "${APP_PATH}"

function fn_main()
{
    ${PYTHON_PATH}/python -u ${APP_PATH}/tools/pyscript/deploy_fi.pyc $1 $2
    deploy_result=$?
    if [[ ${deploy_result} -eq 0 ]]
    then
        echo "deploy success!"
        return 0
    else
        echo "deploy failed, return code = ${deploy_result}"
        return ${deploy_result}
    fi
}

fn_main "$@"
result=$?
. ${APP_PATH}/lbin/syslog.sh $0 $result $@
exit $result
