#!/bin/bash
SOURCE="${BASH_SOURCE[0]}"
SCRIPT_FILE_PATH=`/usr/bin/readlink -e ${SOURCE}`
SCRIPT_DIR=`/usr/bin/dirname ${SCRIPT_FILE_PATH}`
APP_PATH=`/usr/bin/dirname ${SCRIPT_DIR}`
PYTHON_PATH=${APP_PATH}/rtsp/python/bin

function uninstall_cluster()
{
    if [[ -f /opt/huawei/Bigdata/om-agent/nodeagent/setup/uninstall.sh ]]; then
        bash /opt/huawei/Bigdata/om-agent/nodeagent/setup/uninstall.sh
        result=$?
        if [[ ${result} == 0 ]]; then
            echo "uninstall FI cluster success"
            return 0
        fi
        echo "uninstall FI cluster failed"
        return 1
    fi
    echo "FI cluster not exist on this node, no need to uninstall"
    return 0

}

function uninstall_manager()
{
    if [[ -f /opt/huawei/Bigdata/om-server/om/inst/uninstall.sh ]]; then
        bash /opt/huawei/Bigdata/om-server/om/inst/uninstall.sh<<eof
y
eof
        result=$?
        if [[ ${result} == 0 ]]; then
            echo "uninstall FI manager success"
            return 0
        fi
        echo "uninstall FI manager failed"
        return 1
    fi
    echo "FI manager not exist on this node, no need to uninstall"
    return 0

}

function uninstall_fi()
{
    if [[ ${USER} != "root" ]]; then
        echo "only the root user can run this script, now the user is ${USER}"
        return 1
    fi
    if [[ $# -eq 0 ]]; then
        echo "uninstall singleton FI"
        uninstall_cluster
        result1=$?
        if [ $result1 -ne 0 ];then
            return $result1
        fi
        uninstall_manager
        return $?
    elif [[ $# -eq 1 ]]; then
        typeset -l UNINSTALL_MODE
        UNINSTALL_MODE=$1
        if [[ ${UNINSTALL_MODE} == "cluster" ]]; then
            uninstall_cluster
            return $?
        elif [[ ${UNINSTALL_MODE} == "manager" ]]; then
            uninstall_manager
            return $?
        else
            echo "ERROR: please input correct install_mode: cluster/manager"
            return 1
        fi
    else
        echo "ERROR: unsupported input parameters"
    fi
}

. ${APP_PATH}/lbin/env_profile.sh "${APP_PATH}"
${PYTHON_PATH}/python ${APP_PATH}/tools/pyscript/set_firewall_rule.pyc --local --remove
uninstall_fi $@
result=$?
. ${APP_PATH}/lbin/syslog.sh $0 $result $@
exit $result
