#!/bin/bash
if [[ ${USER} != "root" ]]; then
    echo "only the root user can run this script, current the user is ${USER}"
    exit 1
fi
SOURCE="${BASH_SOURCE[0]}"
SCRIPT_FILE_PATH=`/usr/bin/readlink -e ${SOURCE}`
SCRIPT_DIR=`/usr/bin/dirname ${SCRIPT_FILE_PATH}`
APP_PATH=`/usr/bin/dirname ${SCRIPT_DIR}`
PYTHON_PATH=${APP_PATH}/rtsp/python/bin

. ${APP_PATH}/lbin/env_profile.sh "${APP_PATH}"
${PYTHON_PATH}/python -u ${APP_PATH}/tools/util/fi_client/install_fi_client.pyc
result=$?
if [ ${result} -ne 0 ]; then
    echo "Install client failed."
fi
. ${APP_PATH}/lbin/syslog.sh $0 $result $@
exit $result
