#!/bin/bash
################################################################################
## Copyright:   HUAWEI Tech. Co., Ltd.
## Filename:    pre_check.sh
## Des: 安装/扩容预检查
################################################################################

if [[ ${USER} != "root" ]]; then
    echo "only the root user can run this script, now the user is ${USER}"
    exit 1
fi

###################################################################
#set the path
###################################################################
SOURCE="${BASH_SOURCE[0]}"
SCRIPT_FILE_PATH=`/usr/bin/readlink -e ${SOURCE}`
SCRIPT_DIR=`/usr/bin/dirname ${SCRIPT_FILE_PATH}`
APP_PATH=$(readlink -e $0 |xargs dirname |xargs dirname)
SWIFT_PYTHON=${APP_PATH}/rtsp/python/bin/python

# init first
if [ -f ${APP_PATH}/lbin/init_deploy.sh ]; then
    cd ${APP_PATH}/lbin
    bash init_deploy.sh
fi
. ${APP_PATH}/lbin/env_profile.sh "${APP_PATH}"
${SWIFT_PYTHON} ${APP_PATH}/tools/pyscript/run_install_precheck.pyc
result=$?
. ${APP_PATH}/lbin/syslog.sh $0 $result $@
exit $result

